% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_hamming.R
\name{nd.hamming}
\alias{nd.hamming}
\title{Hamming Distance}
\usage{
nd.hamming(A, out.dist = TRUE)
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Hamming Distance is the count of discrepancy between two binary networks for each edge.
Therefore, if used with non-binary networks, it might return a warning message and distorted results.
It was originally designed to compare two strings of equal length, see \href{https://en.wikipedia.org/wiki/Hamming_distance}{Wikipedia page} for more detailed introduction.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.hamming(A)
image(as.matrix(output$D), main="two group case")

}
\references{
\insertRef{hamming_error_1950}{NetworkDistance}
}
