% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmeans.R
\name{Kmeans}
\alias{Kmeans}
\title{Contour plot of latent node positions}
\usage{
Kmeans(out, n.cluster = 2, vertex.names = NULL, main = "")
}
\arguments{
\item{out}{Output of networkchange objects.}

\item{n.cluster}{The number of latent block in network for k-means clustering}

\item{vertex.names}{The vertex names}

\item{main}{The title of plot}
}
\value{
A plot object
}
\description{
Draw a contour plot of latent node positions
}
\examples{

   \dontrun{set.seed(1973)
    ## generate an array with three blocks
set.seed(11173)

## The number of node in each block is
N <- 5

## Generate block-splitting network time series data
Yarr <- MakeBlockNetworkChange(n=N, break.point = .5,
        base.prob=.05, block.prob=.5, shape=1, T=20, type ="split")

## Pick is a homophily network with 3 blocks
Y1 <- Yarr[,,16]

## Y2 is a mirror image of Y1, which is heterophilous
Y2 <- 1-Yarr[,,20]
diag(Y2) <- 0

## Combine them into a multilayer network array
Y <- abind(Y1, Y2, along=3)

G <- 100 ## Small mcmc scans to save time
out0 <- NetworkStatic(Y, R=2,  mcmc = G, burnin = G,
        constant=FALSE, verbose= G, degree.normal="eigen")
plot3 <- Kmeans(out0, n.cluster=3, main="(C) Recovered Three Blocks")

require (sna)
g1 <- network(Y[,,1], directed = FALSE)
g2 <- network(Y[,,2], directed = FALSE)

require(ggnet)
plot1 <- ggnet2(g1, node.size = 4, label.size=3,
    label = plot3$data$names, color = rep(c("red", "green", "blue"), each=N),
    label.color = "white", alpha = 0.5) + ggtitle("(A) Network Layer 1")
plot2 <- ggnet2(g2, node.size = 4, label.size=3,
    label = plot3$data$names, color = rep(c("red", "green", "blue"), each=N),
    label.color = "white", alpha = 0.5) + ggtitle("(B) Network Layer 2")
multiplot(plot1, plot2, plot3, cols=3)

}
}
