% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen-defs.R
\name{common_params}
\alias{common_params}
\title{Template parameters}
\arguments{
\item{network}{a list of interaction networks, one for each dataset. Each 
entry of the list should be a \eqn{n * n} matrix or where each element 
contains the edge weight between nodes \eqn{i} and \eqn{j} in the inferred 
network for that dataset.}

\item{data}{a list of matrices, one for each dataset. Each entry of the list 
should be the data used to infer the interaction \code{network} for that 
dataset. The columns should correspond to variables in the data
(nodes in the network) and rows to samples in that dataset.}

\item{correlation}{a list of matrices, one for each dataset. Each entry of
the list should be a \eqn{n * n} matrix where each element contains the 
correlation coefficient between nodes \eqn{i} and \eqn{j} in the 
\code{data} used to infer the interaction network for that dataset.}

\item{moduleAssignments}{a list of vectors, one for each \emph{discovery} 
dataset, containing the module assignments for each node in that dataset.}

\item{modules}{a list of vectors, one for each \code{discovery} dataset, 
of modules to perform the analysis on. If unspecified, all modules
in each \code{discovery} dataset will be analysed, with the exception of 
those specified in \code{backgroundLabel} argument.}

\item{backgroundLabel}{a single label given to nodes that do not belong to 
any module in the \code{moduleAssignments} argument.}

\item{discovery}{a vector of names or indices denoting the \emph{discovery}
dataset(s) in the \code{data}, \code{correlation}, \code{network}, 
\code{moduleAssignments}, \code{modules}, and \code{test} lists.}

\item{test}{a list of vectors, one for each \code{discovery} dataset,
of names or indices denoting the \emph{test} dataset(s) in the \code{data}, 
\code{correlation}, and \code{network} lists.}

\item{verbose}{logical; should progress be reported? Default is \code{TRUE}.}
}
\description{
Template parameters to be imported into other function documentation. This 
is not intended to be a stand-alone help file.
}
\keyword{internal}

