% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPlot.R
\name{numLayers,worldArray-method}
\alias{numLayers,worldArray-method}
\alias{.plotGrob,agentMatrix-method}
\alias{layerNames,worldArray-method}
\alias{.identifyGrobToPlot,worldArray,.quickPlotGrob-method}
\title{Methods for \code{quickPlot}}
\usage{
\S4method{numLayers}{worldArray}(x)

\S4method{.plotGrob}{agentMatrix}(
  grobToPlot,
  col = NULL,
  real = FALSE,
  size = unit(5, "points"),
  minv,
  maxv,
  legend = TRUE,
  legendText = NULL,
  length = NULL,
  gp = gpar(),
  gpText = gpar(),
  pch = 19,
  speedup = 1,
  name = character(),
  vp = list(),
  ...
)

\S4method{layerNames}{worldArray}(object)

\S4method{.identifyGrobToPlot}{worldArray,.quickPlotGrob}(toPlot, sGrob, takeFromPlotObj)
}
\arguments{
\item{x}{A \code{.quickPlotObjects} object or list of these.}

\item{grobToPlot}{\code{Raster*}, \code{SpatialLines*},
\code{SpatialPoints*}, or \code{SpatialPolygons*} object.}

\item{col}{Currently only used for the legend of a \code{Raster*} object.}

\item{real}{Logical indicating whether the data are \code{real} numbers
(i.e., as opposed to \code{integer} or \code{factor}).}

\item{size}{The size of the \code{SpatialPoints}.}

\item{minv}{The minimum value on a \code{Raster*}. Required because not
all Rasters have this defined internally.}

\item{maxv}{The maximum value on a \code{Raster*}. Required because not
all Rasters have this defined internally.}

\item{legend}{Logical indicating whether a legend should be drawn.
Default \code{TRUE}.}

\item{legendText}{Vector of values to use for legend value labels.
Defaults to \code{NULL} which results in a pretty numeric
representation. If \code{Raster*} has a Raster Attribute
Table (rat; see \pkg{raster} package), this will be used
by default. Currently, only a single vector is accepted.}

\item{length}{Numeric.}

\item{gp}{\code{grid} parameters, usually the output of a call to
\code{\link[quickPlot]{gpar}}.}

\item{gpText}{\code{gpar} object for legend label text.}

\item{pch}{Point character for \code{SpatialPoints}, as \code{par}.}

\item{speedup}{Numeric. The factor by which the number of vertices in
\code{SpatialPolygons} and \code{SpatialLines*} will be
subsampled. The vertices are already subsampled by default to
make plotting faster.}

\item{name}{Character string of name of object being plotted.}

\item{vp}{whole viewport tree of \code{quickPlotGrob}}

\item{...}{Additional arguments. None currently implemented.}

\item{object}{A \code{Raster*}, \code{SpatialPoints*}, \code{SpatialLines*},
or \code{SpatialPolygons*} object; or list of these.}

\item{toPlot}{The object to plot. Should be a single layer if from a multi-layer
object such as a RasterStack.}

\item{sGrob}{quickPlot grob object}

\item{takeFromPlotObj}{Logical. Should the data come from the argument passed
into Plot (\code{TRUE}), or from the (\code{.quickPlotEnv})
(\code{FALSE}).}
}
\description{
These are required to create plotting methods to work with \pkg{quickPlot}.
}
