% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_database.R
\name{NasdaqDataLink.database.bulk_download_url}
\alias{NasdaqDataLink.database.bulk_download_url}
\title{Returns the bulk download url}
\usage{
NasdaqDataLink.database.bulk_download_url(database_code, ...)
}
\arguments{
\item{database_code}{Database code on Nasdaq Data Link specified as a string.}

\item{...}{Additional named values that are interpreted as Nasdaq Data Link API parameters. Please see \url{https://docs.data.nasdaq.com/docs/parameters-2} for a full list of parameters.}
}
\value{
Returns the download url.
}
\description{
Returns the bulk download url
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
url = NasdaqDataLink.database.download_url("NSE", download_type="partial")
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
