% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{VN.reg}
\alias{VN.reg}
\title{VN Regression}
\usage{
VN.reg(x, y, order = NULL, type = NULL, point.est = NULL,
  location = "top", print.values = FALSE, print.equation = FALSE,
  return.values = FALSE, return.equation = FALSE, plot = TRUE,
  threshold = 0)
}
\arguments{
\item{x}{Independent Variable(s)}

\item{y}{Dependent Variable}

\item{order}{Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{order=} settings.  \code{order='max'} will use maximum suggested possible order based on number of observations.}

\item{type}{To perform logistic regression, set to \code{type = "LOGIT"}.  Defualts to NULL.}

\item{point.est}{Returns the fitted value for any value of the independent variable.  Use a vector of values for independent varaiables to return the multiple regression fitted value.}

\item{location}{Sets the legend location within the plot}

\item{print.values}{Defaults to FALSE, set to TRUE in order to print all fitted values for independent variable}

\item{print.equation}{Defaults to FALSE, set to TRUE in order to print the local coefficients (partial derivative wrt independen variable) for a given range of the independent variable}

\item{return.values}{Defaults to FALSE, set to TRUE in order to return fitted values into a vector.}

\item{return.equation}{Defaults to FALSE, set to TRUE in order to return the local coefficients (partial derivative wrt independent variable) for a given range of the independent variable}

\item{plot}{To plot regression or not.  Defaults to TRUE.}

\item{threshold}{Sets the correlation threshold for independent variables.  Defaults to 0.}
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
VN.reg(x,y)

## Manual {order} selection
VN.reg(x,y,order=2)

## Maximum {order} selection
VN.reg(x,y,order='max')

## x-only paritioning
VN.reg(x,y,type="XONLY")

## For Multiple Regression based on Synthetic X*:
x<-cbind(rnorm(100),rnorm(100),rnorm(100)); y<-rnorm(100)
VN.reg(x,y,point.est=c(.25,.5,.75))

## To call fitted values:
VN.reg(x,y,return.values=TRUE)$fitted

## To call partial derivative:
VN.reg(x,y,return.equation=TRUE)$derivative

}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{nonlinear}
\keyword{regression}

