% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMsim_VarCov.R
\name{NMsim_VarCov}
\alias{NMsim_VarCov}
\title{Simulate with parameter values sampled from a covariance step}
\usage{
NMsim_VarCov(file.sim, file.mod, data.sim, nsims = 1)
}
\arguments{
\item{file.sim}{See \code{?NMsim}.}

\item{file.mod}{See \code{?NMsim}.}

\item{data.sim}{See \code{?NMsim}.}

\item{nsims}{Number of replications wanted. The default is 1. If
greater, multiple control streams will be generated.}
}
\value{
Character vector of simulation control stream paths
}
\description{
Like \code{NMsim_default} but `$THETA`, `$OMEGA`, and `SIGMA` are
drawn from distribution estimated in covariance step. This means
that a successful covariance step must be available from the
estimation. In case the simulation leads to negative diagonal
elements in $OMEGA and $SIGMA, those values are truncated at
zero. For simulation with parameter variability based on bootstrap
results, use \code{NMsim_default}.
}
