% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm_object.R
\name{new_nm}
\alias{new_nm}
\title{Create a new (parent) nm object}
\usage{
new_nm(based_on, run_id = NA_character_, data_path, cmd)
}
\arguments{
\item{based_on}{Character. Relative path to an existing control file from
which to base this run.  NMproject will not modify or run this control
file.  Instead it will create a new control file specified by the
\code{ctl_name} field (see Details below).}

\item{run_id}{Character. Run identifier. This is used to name the run and
output files such as $TABLE outputs.}

\item{data_path}{Character. Path to dataset. If this is not specified,
NMproject will try to guess based on the current $DATA components of the
file specified in \code{based_on}.  However it is recommended to specify this
explicitly as a relative path.}

\item{cmd}{Optional character. PsN command to use. If unspecified will use
\code{getOption("nm.cmd_default")}. Use glue notation for inheritance.  See
details.}
}
\value{
An object of class \code{nm_list}.  Attributes can be viewed by printing
the object in the console.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Create a new parent \code{nm} object.  Normally the first NONMEM object you create
will be using this function.  Subsequent objects created with the \code{\link[=child]{child()}}
function will inherit the properties of the parent run.
}
\details{
The \code{cmd} field uses \code{glue} notation.  So instead of specifying
\verb{execute runm1.mod -dir=m1}, it is best to specify \verb{execute \{ctl_name\} -dir=\{run_dir\}}.  The values of \code{ctl_name} and \code{run_dir} refer to object
fields and if these change value like when the \code{child()} function is used to
create a separate child object, the \code{cmd} field will update automatically.
}
\section{Object fields}{


Each field has a corresponding function (documented in \link{nm_getsetters}) of
the same name to access and modify it's value.

\describe{
\item{type}{
The PsN run type.  Default is \code{execute}.
}
\item{run_id}{
The run identifier.  E.g. \code{m1}.
}
\item{run_in}{
The directory to copy control files and run NONMEM.  Default = "Models".
}
\item{executed}{
For internal use.
}
\item{ctl_contents}{
Stores the contents of the control file to be written to disk when the
\code{\link[=run_nm]{run_nm()}} function is used on the object.
}
\item{data_path}{
Path to the NONMEM ready dataset (from base project directory).
}
\item{cmd}{
See details above.
}
\item{cores}{
Numbers of cores to use.  Requires a \code{cmd} value that uses the \code{{cores}}
glue field.
}
\item{run_dir}{
PsN directory to run the NONMEM run. Default is to the be the same as
the \code{run_id} for simplicity.
}
\item{results_dir}{
Location to store results files from diagnostic reports executed with
\code{\link[=nm_render]{nm_render()}}.
}
\item{unique_id}{
For internal use.
}
\item{lst_path}{
Normally does not require setting.  Path to the expected .lst file.
}
}
}

\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 ## display object fields
cmd(m1)
ctl_name(m1)
run_dir(m1)

}
\seealso{
\code{\link[=nm_getsetters]{nm_getsetters()}}, \code{\link[=child]{child()}}
}
