% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMstamp.R
\name{NMstamp}
\alias{NMstamp}
\title{stamp a dataset or any other object}
\usage{
NMstamp(data, script, time = Sys.time(), ...)
}
\arguments{
\item{data}{The dataset to stamp.}

\item{script}{path to the script where the dataset was generated.}

\item{time}{the time stamp to attach. Default is to use cpu clock.}

\item{...}{other named metadata elements to add to the dataset. Example:
Description="PK data for ph1 trials in project".}
}
\value{
data with meta data attached. Class unchanged.
}
\description{
Dataset metadata can be valuable, eg. by tracing an archived dataset
back to the code that generated it. The metadata added by
NMstamp can be accessed using the function NMinfo.
}
\details{
NMstamp modifies the meta data by reference. See example.
}
\examples{
x=1
NMstamp(x,script="example.R",description="Example data")
NMinfo(x)
}
\seealso{
NMinfo

Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{findCovs}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
