% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_weights.R
\name{enforce_nonneg_weights}
\alias{enforce_nonneg_weights}
\title{Enforce (near-)nonnegativity of weights}
\usage{
enforce_nonneg_weights(weights, tol = 1e-08)
}
\arguments{
\item{weights}{numeric vector of weights.}

\item{tol}{numeric tolerance below which negative values are treated as
numerical noise and clipped to zero.}
}
\value{
A list with components:
  \describe{
    \item{\code{ok}}{logical; \code{TRUE} if no clearly negative weights
      were found.}
    \item{\code{message}}{character; diagnostic message when \code{ok} is
      \code{FALSE}, otherwise \code{NULL}.}
    \item{\code{weights}}{numeric vector of adjusted weights (original if
      \code{ok} is \code{FALSE}, otherwise with small negatives clipped to
      zero).}
  }
}
\description{
Softly enforces nonnegativity of a numeric weight vector. Large negative
values (beyond a tolerance) are treated as errors; small negative values
(for example, from numerical noise) are truncated to zero.
}
\details{
Values below \code{-tol} are treated as clearly negative. Values in
\code{[-tol, 0)} are clipped to zero.
}
\keyword{internal}
