% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBIC.R
\name{OBIC}
\alias{OBIC}
\title{Calculates BIC, AIC, PLS, log-likelihood}
\usage{
OBIC(nhmmobj, outfile = NULL)
}
\arguments{
\item{nhmmobj}{an object created from the NHMM function}

\item{outfile}{a directory to put the .png plot}
}
\value{
BIC

output: AIC, BIC, PLS [if yhold data was provided], log-likelihood to the GUI and a plot of the log-likelihood
}
\description{
\code{OBIC} calculates BIC, AIC, approximate log-likelihood and plots the
log-likelihood for all iterations. The log-likelihood plot should 
be flat to show convergence to a stationary distribution. Minimize 
the AIC and BIC for the *best* model and maximize PLS.  The log likelihood is approximate in that
it is calculated by marginalizing over the current chain of hidden states instead
of using a recurrsive algorithm to compute it; every iterations produces an estimation
of the log-likelihood.  If yhold is provided the preditive log score (PLS) is also 
given.
}
\details{
Predictive Log Score: mean(log( E(p(yhold|...)))  The expectation is over all of the
iterations of the algorithm.  And the mean is over the pT count of yhold. The scale of
the PLS is in the unit of t (usually days).
}
\examples{
#OBIC(my.nhmm) 
}
\keyword{AIC}
\keyword{BIC}
\keyword{PLS}
\keyword{log-likelihood}

