% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise.R
\name{visualise}
\alias{visualise}
\alias{visualize}
\title{Visualise quality-control metrics using a shiny app}
\usage{
visualise(nacho_object)
}
\arguments{
\item{nacho_object}{[\link{list}] List obtained from \link{summarise} or \link{normalise}.}
}
\description{
This function allows to visualise several quality-control metrics
in an interactive \link{shiny} application, in which thresholds can be customised
and exported to the global environment.
}
\examples{

if (interactive()) {
  data(GSE74821)
  # Must be run in an interactive R session!
  visualise(GSE74821)
}

if (interactive()) {
  library(GEOquery)
  library(NACHO)

  # Import data from GEO
  gse <- GEOquery::getGEO(GEO = "GSE74821")
  targets <- Biobase::pData(Biobase::phenoData(gse[[1]]))
  GEOquery::getGEOSuppFiles(GEO = "GSE74821", baseDir = tempdir())
  utils::untar(
    tarfile = paste0(tempdir(), "/GSE74821/GSE74821_RAW.tar"),
    exdir = paste0(tempdir(), "/GSE74821")
  )
  targets$IDFILE <- list.files(
    path = paste0(tempdir(), "/GSE74821"),
    pattern = ".RCC.gz$"
  )
  targets[] <- lapply(X = targets, FUN = iconv, from = "latin1", to = "ASCII")
  utils::write.csv(
    x = targets,
    file = paste0(tempdir(), "/GSE74821/Samplesheet.csv")
  )

  # Read RCC files and format
  nacho <- summarise(
    data_directory = paste0(tempdir(), "/GSE74821"),
    ssheet_csv = paste0(tempdir(), "/GSE74821/Samplesheet.csv"),
    id_colname = "IDFILE"
  )
  visualise(nacho)

  # (re)Normalise data by removing outliers
  nacho_norm <- normalise(
    nacho_object = nacho,
    remove_outliers = TRUE
  )
  visualise(nacho_norm)

  # (re)Normalise data with "GLM" method and removing outliers
  nacho_norm <- normalise(
    nacho_object = nacho,
    normalisation_method = "GLM",
    remove_outliers = TRUE
  )
  visualise(nacho_norm)
}

}
