/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class MatrixUtils {
    private MatrixUtils() {
    }

    public static void write(Path outputDir, Configuration conf, VectorIterable matrix) throws IOException {
        FileSystem fs = outputDir.getFileSystem(conf);
        fs.delete(outputDir, true);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)outputDir, IntWritable.class, VectorWritable.class);
        IntWritable topic = new IntWritable();
        VectorWritable vector = new VectorWritable();
        for (MatrixSlice slice : matrix) {
            topic.set(slice.index());
            vector.set(slice.vector());
            writer.append((Writable)topic, (Writable)vector);
        }
        writer.close();
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix read(Configuration conf, Path ... modelPaths) throws IOException {
        DenseMatrix matrix;
        void var8_10;
        int numRows = -1;
        int numCols = -1;
        boolean sparse = false;
        ArrayList<Pair<Integer, Vector>> rows = Lists.newArrayList();
        Path[] arr$ = modelPaths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_10 < len$) {
            Path modelPath = arr$[var8_10];
            for (Pair row : new SequenceFileIterable(modelPath, true, conf)) {
                rows.add(Pair.of(((IntWritable)row.getFirst()).get(), ((VectorWritable)((Object)row.getSecond())).get()));
                numRows = Math.max(numRows, ((IntWritable)row.getFirst()).get());
                boolean bl2 = sparse = !((VectorWritable)((Object)row.getSecond())).get().isDense();
                if (numCols >= 0) continue;
                numCols = ((VectorWritable)((Object)row.getSecond())).get().size();
            }
            ++var8_10;
        }
        if (rows.isEmpty()) {
            throw new IOException(Arrays.toString((Object[])modelPaths) + " have no vectors in it");
        }
        Vector[] arrayOfRows = new Vector[++numRows];
        for (Pair pair : rows) {
            arrayOfRows[((Integer)pair.getFirst()).intValue()] = (Vector)pair.getSecond();
        }
        if (sparse) {
            matrix = new SparseRowMatrix(numRows, numCols, arrayOfRows);
        } else {
            void var8_13;
            matrix = new DenseMatrix(numRows, numCols);
            boolean bl3 = false;
            while (var8_13 < numRows) {
                matrix.assignRow((int)var8_13, arrayOfRows[var8_13]);
                ++var8_13;
            }
        }
        return matrix;
    }

    public static OpenObjectIntHashMap<String> readDictionary(Configuration conf, Path ... dictPath) {
        OpenObjectIntHashMap dictionary = new OpenObjectIntHashMap();
        for (Path dictionaryFile : dictPath) {
            for (Pair record : new SequenceFileIterable(dictionaryFile, true, conf)) {
                dictionary.put((Object)((Writable)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
            }
        }
        return dictionary;
    }

    public static String[] invertDictionary(OpenObjectIntHashMap<String> termIdMap) {
        int maxTermId = -1;
        for (String term : termIdMap.keys()) {
            maxTermId = Math.max(maxTermId, termIdMap.get((Object)term));
        }
        String[] dictionary = new String[++maxTermId];
        Iterator i$ = termIdMap.keys().iterator();
        while (i$.hasNext()) {
            String term;
            dictionary[termIdMap.get((Object)term)] = term = (String)i$.next();
        }
        return dictionary;
    }
}

