/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MutableRecommendedItem;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.OneWayMigrator;
import net.myrrix.common.ReloadingReference;
import net.myrrix.common.TopN;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.math.SimpleVectorMath;
import net.myrrix.common.math.Solver;
import net.myrrix.common.parallel.ExecutorUtils;
import net.myrrix.online.MostPopularItemsIterator;
import net.myrrix.online.MostSimilarItemIterator;
import net.myrrix.online.RecommendIterator;
import net.myrrix.online.RecommendedBecauseIterator;
import net.myrrix.online.candidate.CandidateFilter;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.GenerationManager;
import net.myrrix.online.generation.IDCluster;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.IDMigrator;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerRecommender
implements MyrrixRecommender,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ServerRecommender.class);
    private static final Splitter DELIMITER = Splitter.on(CharMatcher.anyOf(",\t")).trimResults();
    private static final double FOLDIN_LEARN_RATE = Double.parseDouble(System.getProperty("model.foldin.learningRate", "1.0"));
    private static final double BIG_FOLDIN_THRESHOLD = Double.parseDouble(System.getProperty("model.foldin.bigThreshold", "10000.0"));
    private final GenerationManager generationManager;
    private final int numCores;
    private final ReloadingReference<ExecutorService> executor;
    private final IDMigrator tagHasher;

    public ServerRecommender(File localInputDir) {
        this(null, null, localInputDir, 0, null);
    }

    public ServerRecommender(String bucket, String instanceID, File localInputDir, int partition, ReloadingReference<List<List<HostAndPort>>> allPartitions) {
        Preconditions.checkNotNull(localInputDir, "No local dir");
        if (bucket == null || instanceID == null) {
            log.info("Creating ServerRecommender with local input dir {}", (Object)localInputDir);
        } else {
            log.info("Creating ServerRecommender for bucket {}, instance {} and with local input dir {}, partition {}", bucket, instanceID, localInputDir, partition);
        }
        this.generationManager = ClassUtils.loadInstanceOf("net.myrrix.online.generation.DelegateGenerationManager", GenerationManager.class, new Class[]{String.class, String.class, File.class, Integer.TYPE, ReloadingReference.class}, new Object[]{bucket, instanceID, localInputDir, partition, allPartitions});
        this.numCores = Runtime.getRuntime().availableProcessors();
        this.executor = new ReloadingReference<ExecutorService>(new Callable<ExecutorService>(){

            @Override
            public ExecutorService call() {
                return Executors.newFixedThreadPool(2 * ServerRecommender.this.numCores, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ServerRecommender-%d").build());
            }
        });
        this.tagHasher = new OneWayMigrator();
    }

    public String getBucket() {
        return this.generationManager.getBucket();
    }

    public String getInstanceID() {
        return this.generationManager.getInstanceID();
    }

    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    @Deprecated
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (alreadyRefreshed != null) {
            log.warn("Ignoring argument {}", (Object)alreadyRefreshed);
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.generationManager.refresh();
    }

    @Override
    public void ingest(File file) throws TasteException {
        Reader reader = null;
        try {
            reader = IOUtils.openReaderMaybeDecompressing(file);
            this.ingest(reader);
        }
        catch (IOException ioe) {
            throw new TasteException(ioe);
        }
        finally {
            try {
                Closeables.close(reader, true);
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void ingest(Reader reader) throws TasteException {
        BufferedReader buffered = IOUtils.buffer(reader);
        try {
            String line;
            int lines = 0;
            int badLines = 0;
            while ((line = buffered.readLine()) != null) {
                float value;
                if (badLines > 100) {
                    throw new IOException("Too many bad lines; aborting");
                }
                ++lines;
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                Iterator<String> it = DELIMITER.split(line).iterator();
                long userID = Long.MIN_VALUE;
                String itemTag = null;
                long itemID = Long.MIN_VALUE;
                String userTag = null;
                try {
                    String valueToken;
                    String userIDString = it.next();
                    if (userIDString.startsWith("\"")) {
                        itemTag = userIDString.substring(1, userIDString.length() - 1);
                    } else {
                        userID = Long.parseLong(userIDString);
                    }
                    String itemIDString = it.next();
                    if (itemIDString.startsWith("\"")) {
                        userTag = itemIDString.substring(1, itemIDString.length() - 1);
                    } else {
                        itemID = Long.parseLong(itemIDString);
                    }
                    value = it.hasNext() ? ((valueToken = it.next()).isEmpty() ? Float.NaN : LangUtils.parseFloat(valueToken)) : 1.0f;
                }
                catch (NoSuchElementException ignored) {
                    log.warn("Ignoring line with too few columns: '{}'", (Object)line);
                    ++badLines;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    if (lines == 1) {
                        log.info("Ignoring header line: '{}'", (Object)line);
                        continue;
                    }
                    log.warn("Ignoring unparseable line: '{}'", (Object)line);
                    ++badLines;
                    continue;
                }
                boolean remove = Float.isNaN(value);
                if (itemTag != null) {
                    if (userTag != null) {
                        log.warn("Two tags not allowed: '{}'", (Object)line);
                        ++badLines;
                        continue;
                    }
                    if (!remove) {
                        this.setItemTag(itemTag, itemID, value, true);
                    }
                } else if (userTag != null) {
                    if (!remove) {
                        this.setUserTag(userID, userTag, value, true);
                    }
                } else if (remove) {
                    this.removePreference(userID, itemID, true);
                } else {
                    this.setPreference(userID, itemID, value, true);
                }
                if (lines % 1000000 != 0) continue;
                log.info("Finished {} lines", (Object)lines);
            }
            this.generationManager.bulkDone();
        }
        catch (IOException ioe) {
            throw new TasteException(ioe);
        }
    }

    @Override
    public void close() throws IOException {
        this.generationManager.close();
        ExecutorService executorService = this.executor.maybeGet();
        if (executorService != null) {
            ExecutorUtils.shutdownNowAndAwait(executorService);
        }
    }

    private Generation getCurrentGeneration() throws NotReadyException {
        Generation generation = this.generationManager.getCurrentGeneration();
        if (generation == null) {
            throw new NotReadyException();
        }
        return generation;
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany) throws NoSuchUserException, NotReadyException {
        return this.recommend(userID, howMany, null);
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws NoSuchUserException, NotReadyException {
        return this.recommend(userID, howMany, false, rescorer);
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws NoSuchUserException, NotReadyException {
        return this.recommendToMany(new long[]{userID}, howMany, considerKnownItems, rescorer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> recommendToMany(long[] userIDs, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws NoSuchUserException, NotReadyException {
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> X = generation.getX();
        Lock xLock = generation.getXLock().readLock();
        ArrayList<float[]> userFeatures = Lists.newArrayListWithCapacity(userIDs.length);
        xLock.lock();
        try {
            for (long userID : userIDs) {
                float[] theUserFeatures = X.get(userID);
                if (theUserFeatures == null) continue;
                userFeatures.add(theUserFeatures);
            }
        }
        finally {
            xLock.unlock();
        }
        if (userFeatures.isEmpty()) {
            throw new NoSuchUserException(Arrays.toString(userIDs));
        }
        FastByIDMap<FastIDSet> knownItemIDs = generation.getKnownItemIDs();
        if (knownItemIDs == null && !considerKnownItems) {
            throw new UnsupportedOperationException("Can't ignore known items because no known items available");
        }
        FastIDSet usersKnownItemIDs = null;
        if (!considerKnownItems) {
            Lock knownItemLock = generation.getKnownItemLock().readLock();
            knownItemLock.lock();
            try {
                for (long userID : userIDs) {
                    FastIDSet theKnownItemIDs = knownItemIDs.get(userID);
                    if (theKnownItemIDs == null) continue;
                    if (usersKnownItemIDs == null) {
                        usersKnownItemIDs = theKnownItemIDs;
                    } else {
                        LongPrimitiveIterator it = usersKnownItemIDs.iterator();
                        while (it.hasNext()) {
                            if (theKnownItemIDs.contains(it.nextLong())) continue;
                            it.remove();
                        }
                    }
                    if (!usersKnownItemIDs.isEmpty()) continue;
                    break;
                }
            }
            finally {
                knownItemLock.unlock();
            }
        }
        float[][] userFeaturesArray = (float[][])userFeatures.toArray((T[])new float[userFeatures.size()][]);
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            List<RecommendedItem> list = this.multithreadedTopN(userFeaturesArray, usersKnownItemIDs, generation.getUserTagIDs(), rescorer, howMany, generation.getCandidateFilter());
            return list;
        }
        finally {
            yLock.unlock();
        }
    }

    private List<RecommendedItem> multithreadedTopN(final float[][] userFeatures, final FastIDSet userKnownItemIDs, final FastIDSet userTagIDs, final IDRescorer rescorer, final int howMany, CandidateFilter candidateFilter) {
        Collection<Iterator<FastByIDMap.MapEntry<float[]>>> candidateIterators = candidateFilter.getCandidateIterator(userFeatures);
        int numIterators = candidateIterators.size();
        int parallelism = FastMath.min(this.numCores, numIterators);
        final Queue<MutableRecommendedItem> topN = TopN.initialQueue(howMany);
        if (parallelism > 1) {
            ExecutorService executorService = this.executor.get();
            final Iterator<Iterator<FastByIDMap.MapEntry<float[]>>> candidateIteratorsIterator = candidateIterators.iterator();
            ArrayList<Future<Void>> futures = Lists.newArrayList();
            for (int i = 0; i < this.numCores; ++i) {
                futures.add(executorService.submit(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() {
                        float[] queueLeastValue = new float[]{Float.NEGATIVE_INFINITY};
                        while (true) {
                            Iterator candidateIterator;
                            Iterator iterator = candidateIteratorsIterator;
                            synchronized (iterator) {
                                if (!candidateIteratorsIterator.hasNext()) {
                                    break;
                                }
                                candidateIterator = (Iterator)candidateIteratorsIterator.next();
                            }
                            RecommendIterator partialIterator = new RecommendIterator(userFeatures, candidateIterator, userKnownItemIDs, userTagIDs, rescorer);
                            TopN.selectTopNIntoQueueMultithreaded(topN, queueLeastValue, partialIterator, howMany);
                        }
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }
        } else {
            for (Iterator<FastByIDMap.MapEntry<float[]>> candidateIterator : candidateIterators) {
                RecommendIterator partialIterator = new RecommendIterator(userFeatures, candidateIterator, userKnownItemIDs, userTagIDs, rescorer);
                TopN.selectTopNIntoQueue(topN, partialIterator, howMany);
            }
        }
        return TopN.selectTopNFromQueue(topN, howMany);
    }

    @Override
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, int howMany) throws NotReadyException, NoSuchItemException {
        return this.recommendToAnonymous(itemIDs, howMany, null);
    }

    @Override
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, float[] values, int howMany) throws NotReadyException, NoSuchItemException {
        return this.recommendToAnonymous(itemIDs, values, howMany, null);
    }

    @Override
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, int howMany, IDRescorer rescorer) throws NotReadyException, NoSuchItemException {
        return this.recommendToAnonymous(itemIDs, null, howMany, rescorer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, float[] values, int howMany, IDRescorer rescorer) throws NotReadyException, NoSuchItemException {
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        float[] anonymousUserFeatures = this.buildAnonymousUserFeatures(itemIDs, values);
        FastIDSet userKnownItemIDs = new FastIDSet(itemIDs.length, 1.25f);
        for (long itemID : itemIDs) {
            userKnownItemIDs.add(itemID);
        }
        float[][] anonymousFeaturesAsArray = new float[][]{anonymousUserFeatures};
        Generation generation = this.getCurrentGeneration();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            List<RecommendedItem> list = this.multithreadedTopN(anonymousFeaturesAsArray, userKnownItemIDs, generation.getUserTagIDs(), rescorer, howMany, generation.getCandidateFilter());
            return list;
        }
        finally {
            yLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] buildAnonymousUserFeatures(long[] itemIDs, float[] values) throws NotReadyException, NoSuchItemException {
        Preconditions.checkArgument(values == null || values.length == itemIDs.length, "Number of values doesn't match number of items");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> Y = generation.getY();
        Solver ytySolver = generation.getYTYSolver();
        if (ytySolver == null) {
            throw new NotReadyException();
        }
        float[] anonymousUserFeatures = null;
        Lock yLock = generation.getYLock().readLock();
        boolean anyItemIDFound = false;
        for (int j = 0; j < itemIDs.length; ++j) {
            double signedFoldInWeight;
            float[] itemFeatures;
            long itemID = itemIDs[j];
            yLock.lock();
            try {
                itemFeatures = Y.get(itemID);
            }
            finally {
                yLock.unlock();
            }
            if (itemFeatures == null) continue;
            anyItemIDFound = true;
            double[] userFoldIn = ytySolver.solveFToD(itemFeatures);
            if (anonymousUserFeatures == null) {
                anonymousUserFeatures = new float[userFoldIn.length];
            }
            if ((signedFoldInWeight = ServerRecommender.foldInWeight(0.0, values == null ? 1.0f : values[j])) == 0.0) continue;
            for (int i = 0; i < anonymousUserFeatures.length; ++i) {
                int n = i;
                anonymousUserFeatures[n] = anonymousUserFeatures[n] + (float)(signedFoldInWeight * userFoldIn[i]);
            }
        }
        if (!anyItemIDFound) {
            throw new NoSuchItemException(Arrays.toString(itemIDs));
        }
        return anonymousUserFeatures;
    }

    @Override
    public List<RecommendedItem> mostPopularItems(int howMany) throws NotReadyException {
        return this.mostPopularItems(howMany, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RecommendedItem> mostPopularItems(int howMany, IDRescorer rescorer) throws NotReadyException {
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<FastIDSet> knownItemIDs = generation.getKnownItemIDs();
        if (knownItemIDs == null) {
            throw new UnsupportedOperationException();
        }
        FastIDSet itemTagIDs = generation.getItemTagIDs();
        FastByIDFloatMap itemCounts = new FastByIDFloatMap();
        Lock knownItemReadLock = generation.getKnownItemLock().readLock();
        knownItemReadLock.lock();
        try {
            Lock xReadLock = generation.getXLock().readLock();
            xReadLock.lock();
            try {
                for (FastByIDMap.MapEntry<FastIDSet> entry : generation.getKnownItemIDs().entrySet()) {
                    FastIDSet itemIDs;
                    long userID = entry.getKey();
                    if (itemTagIDs.contains(userID)) continue;
                    FastIDSet fastIDSet = itemIDs = entry.getValue();
                    synchronized (fastIDSet) {
                        LongPrimitiveIterator it = itemIDs.iterator();
                        while (it.hasNext()) {
                            long itemID = it.nextLong();
                            itemCounts.increment(itemID, 1.0f);
                        }
                    }
                }
            }
            finally {
                xReadLock.unlock();
            }
        }
        finally {
            knownItemReadLock.unlock();
        }
        FastIDSet userTagIDs = generation.getUserTagIDs();
        Lock yReadLock = generation.getYLock().readLock();
        yReadLock.lock();
        try {
            LongPrimitiveIterator it = itemCounts.keySetIterator();
            while (it.hasNext()) {
                if (!userTagIDs.contains(it.nextLong())) continue;
                it.remove();
            }
            return TopN.selectTopN(new MostPopularItemsIterator(itemCounts.entrySet().iterator(), rescorer), howMany);
        }
        finally {
            yReadLock.unlock();
        }
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws NotReadyException {
        return this.estimatePreferences(userID, itemID)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] estimatePreferences(long userID, long ... itemIDs) throws NotReadyException {
        float[] userFeatures;
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> X = generation.getX();
        Lock xLock = generation.getXLock().readLock();
        xLock.lock();
        try {
            userFeatures = X.get(userID);
        }
        finally {
            xLock.unlock();
        }
        if (userFeatures == null) {
            return new float[itemIDs.length];
        }
        FastByIDMap<float[]> Y = generation.getY();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            float[] result = new float[itemIDs.length];
            for (int i = 0; i < itemIDs.length; ++i) {
                long itemID = itemIDs[i];
                float[] itemFeatures = Y.get(itemID);
                if (itemFeatures == null) continue;
                float value = (float)SimpleVectorMath.dot(itemFeatures, userFeatures);
                Preconditions.checkState(LangUtils.isFinite(value), "Bad estimate");
                result[i] = value;
            }
            float[] fArray = result;
            return fArray;
        }
        finally {
            yLock.unlock();
        }
    }

    @Override
    public float estimateForAnonymous(long toItemID, long[] itemIDs) throws NotReadyException, NoSuchItemException {
        return this.estimateForAnonymous(toItemID, itemIDs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float estimateForAnonymous(long toItemID, long[] itemIDs, float[] values) throws NotReadyException, NoSuchItemException {
        float[] toItemFeatures;
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> Y = generation.getY();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            toItemFeatures = Y.get(toItemID);
        }
        finally {
            yLock.unlock();
        }
        if (toItemFeatures == null) {
            throw new NoSuchItemException(toItemID);
        }
        float[] anonymousUserFeatures = this.buildAnonymousUserFeatures(itemIDs, values);
        return (float)SimpleVectorMath.dot(anonymousUserFeatures, toItemFeatures);
    }

    @Override
    public void setPreference(long userID, long itemID) {
        this.setPreference(userID, itemID, 1.0f);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) {
        this.setPreference(userID, itemID, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreference(long userID, long itemID, float value, boolean bulk) {
        boolean newItem;
        Generation generation;
        try {
            this.generationManager.append(userID, itemID, value, bulk);
        }
        catch (IOException ioe) {
            log.warn("Could not append datum; continuing", ioe);
        }
        try {
            generation = this.getCurrentGeneration();
        }
        catch (NotReadyException nre) {
            return;
        }
        float[] userFeatures = ServerRecommender.getFeatures(userID, generation.getX(), generation.getXLock());
        Lock yReadLock = generation.getYLock().readLock();
        yReadLock.lock();
        try {
            newItem = generation.getY().get(itemID) == null;
        }
        finally {
            yReadLock.unlock();
        }
        if (newItem) {
            generation.getCandidateFilter().addItem(itemID);
        }
        float[] itemFeatures = ServerRecommender.getFeatures(itemID, generation.getY(), generation.getYLock());
        ServerRecommender.updateFeatures(userFeatures, itemFeatures, value, generation);
        FastByIDMap<FastIDSet> knownItemIDs = generation.getKnownItemIDs();
        if (knownItemIDs != null) {
            FastIDSet userKnownItemIDs;
            block19: {
                ReadWriteLock knownItemLock = generation.getKnownItemLock();
                Lock knownItemReadLock = knownItemLock.readLock();
                knownItemReadLock.lock();
                try {
                    userKnownItemIDs = knownItemIDs.get(userID);
                    if (userKnownItemIDs != null) break block19;
                    userKnownItemIDs = new FastIDSet();
                    Lock knownItemWriteLock = knownItemLock.writeLock();
                    knownItemReadLock.unlock();
                    knownItemWriteLock.lock();
                    try {
                        knownItemIDs.put(userID, userKnownItemIDs);
                    }
                    finally {
                        knownItemReadLock.lock();
                        knownItemWriteLock.unlock();
                    }
                }
                finally {
                    knownItemReadLock.unlock();
                }
            }
            FastIDSet fastIDSet = userKnownItemIDs;
            synchronized (fastIDSet) {
                userKnownItemIDs.add(itemID);
            }
        }
        ServerRecommender.updateClusters(userID, userFeatures, generation.getUserClusters(), generation.getUserClustersLock().readLock());
        ServerRecommender.updateClusters(itemID, itemFeatures, generation.getItemClusters(), generation.getItemClustersLock().readLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] getFeatures(long id, FastByIDMap<float[]> matrix, ReadWriteLock lock) {
        float[] features;
        block6: {
            Lock readLock = lock.readLock();
            readLock.lock();
            try {
                int numFeatures;
                features = matrix.get(id);
                if (features != null || (numFeatures = ServerRecommender.countFeatures(matrix)) <= 0) break block6;
                features = new float[numFeatures];
                Lock writeLock = lock.writeLock();
                readLock.unlock();
                writeLock.lock();
                try {
                    matrix.put(id, features);
                }
                finally {
                    readLock.lock();
                    writeLock.unlock();
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return features;
    }

    private static void updateFeatures(float[] userFeatures, float[] itemFeatures, float value, Generation generation) {
        double delta;
        int i;
        double[] userFoldIn;
        if (userFeatures == null || itemFeatures == null) {
            return;
        }
        double signedFoldInWeight = ServerRecommender.foldInWeight(SimpleVectorMath.dot(userFeatures, itemFeatures), value);
        if (signedFoldInWeight == 0.0) {
            return;
        }
        Solver xtxSolver = generation.getXTXSolver();
        double[] itemFoldIn = xtxSolver == null ? null : xtxSolver.solveFToD(userFeatures);
        Solver ytySolver = generation.getYTYSolver();
        double[] dArray = userFoldIn = ytySolver == null ? null : ytySolver.solveFToD(itemFeatures);
        if (itemFoldIn != null) {
            if (SimpleVectorMath.norm(userFoldIn) > BIG_FOLDIN_THRESHOLD) {
                log.warn("Item fold in vector is large; reduce -Dmodel.features?");
            }
            i = 0;
            while (i < itemFeatures.length) {
                delta = signedFoldInWeight * itemFoldIn[i];
                Preconditions.checkState(LangUtils.isFinite(delta));
                int n = i++;
                itemFeatures[n] = itemFeatures[n] + (float)delta;
            }
        }
        if (userFoldIn != null) {
            if (SimpleVectorMath.norm(userFoldIn) > BIG_FOLDIN_THRESHOLD) {
                log.warn("User fold in vector is large; reduce -Dmodel.features?");
            }
            i = 0;
            while (i < userFeatures.length) {
                delta = signedFoldInWeight * userFoldIn[i];
                Preconditions.checkState(LangUtils.isFinite(delta));
                int n = i++;
                userFeatures[n] = userFeatures[n] + (float)delta;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateClusters(long id, float[] featureVector, Collection<IDCluster> clusters, Lock clustersReadLock) {
        boolean removeFromCurrentCluster;
        FastIDSet newMembers;
        IDCluster closestCentroid;
        if (featureVector == null) return;
        if (clusters == null) return;
        if (clusters.isEmpty()) {
            return;
        }
        clustersReadLock.lock();
        try {
            closestCentroid = ServerRecommender.findClosestCentroid(featureVector, clusters);
        }
        finally {
            clustersReadLock.unlock();
        }
        if (closestCentroid == null) {
            return;
        }
        FastIDSet fastIDSet = newMembers = closestCentroid.getMembers();
        synchronized (fastIDSet) {
            removeFromCurrentCluster = newMembers.add(id);
        }
        if (!removeFromCurrentCluster) return;
        clustersReadLock.lock();
        try {
            Iterator<IDCluster> i$ = clusters.iterator();
            while (i$.hasNext()) {
                FastIDSet oldMembers;
                IDCluster cluster = i$.next();
                FastIDSet fastIDSet2 = oldMembers = cluster.getMembers();
                synchronized (fastIDSet2) {
                    if (oldMembers.remove(id)) {
                        return;
                    }
                }
            }
            return;
        }
        finally {
            clustersReadLock.unlock();
        }
    }

    private static IDCluster findClosestCentroid(float[] vector, Iterable<IDCluster> clusters) {
        double vectorNorm = SimpleVectorMath.norm(vector);
        IDCluster closestCentroid = null;
        double highestDot = Double.NEGATIVE_INFINITY;
        for (IDCluster cluster : clusters) {
            double dot = SimpleVectorMath.dot(cluster.getCentroid(), vector) / cluster.getCentroidNorm() / vectorNorm;
            if (!LangUtils.isFinite(dot) || !(dot > highestDot)) continue;
            highestDot = dot;
            closestCentroid = cluster;
        }
        return closestCentroid;
    }

    private static int countFeatures(FastByIDMap<float[]> M) {
        return M.isEmpty() ? 0 : M.entrySet().iterator().next().getValue().length;
    }

    private static double foldInWeight(double estimate, float value) {
        double signedFoldInWeight;
        Preconditions.checkState(LangUtils.isFinite(estimate));
        if (value > 0.0f && estimate < 1.0) {
            double multiplier = 1.0 - FastMath.max(0.0, estimate);
            signedFoldInWeight = (1.0 - 1.0 / (1.0 + (double)value)) * multiplier;
        } else if (value < 0.0f && estimate > 0.0) {
            double multiplier = -FastMath.min(1.0, estimate);
            signedFoldInWeight = (1.0 - 1.0 / (1.0 - (double)value)) * multiplier;
        } else {
            signedFoldInWeight = 0.0;
        }
        return FOLDIN_LEARN_RATE * signedFoldInWeight;
    }

    @Override
    public void removePreference(long userID, long itemID) {
        this.removePreference(userID, itemID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePreference(long userID, long itemID, boolean bulk) {
        Generation generation;
        try {
            this.generationManager.remove(userID, itemID, bulk);
        }
        catch (IOException ioe) {
            log.warn("Could not append datum; continuing", ioe);
        }
        try {
            generation = this.getCurrentGeneration();
        }
        catch (NotReadyException nre) {
            return;
        }
        ReadWriteLock knownItemLock = generation.getKnownItemLock();
        boolean removeUser = false;
        FastByIDMap<FastIDSet> knownItemIDs = generation.getKnownItemIDs();
        if (knownItemIDs != null) {
            FastIDSet userKnownItemIDs;
            Lock knownItemReadLock = knownItemLock.readLock();
            knownItemReadLock.lock();
            try {
                userKnownItemIDs = knownItemIDs.get(userID);
            }
            finally {
                knownItemReadLock.unlock();
            }
            if (userKnownItemIDs == null) {
                return;
            }
            FastIDSet fastIDSet = userKnownItemIDs;
            synchronized (fastIDSet) {
                if (!userKnownItemIDs.remove(itemID)) {
                    return;
                }
                removeUser = userKnownItemIDs.isEmpty();
            }
        }
        FastByIDMap<float[]> X = generation.getX();
        ReadWriteLock xLock = generation.getXLock();
        if (removeUser) {
            Lock knownItemWriteLock = knownItemLock.writeLock();
            knownItemWriteLock.lock();
            try {
                knownItemIDs.remove(userID);
            }
            finally {
                knownItemWriteLock.unlock();
            }
            Lock xWriteLock = xLock.writeLock();
            xWriteLock.lock();
            try {
                X.remove(userID);
            }
            finally {
                xWriteLock.unlock();
            }
        }
    }

    @Override
    public void setUserTag(long userID, String tag) {
        this.setUserTag(userID, tag, 1.0f);
    }

    @Override
    public void setUserTag(long userID, String tag, float value) {
        this.setUserTag(userID, tag, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserTag(long userID, String tag, float value, boolean bulk) {
        Generation generation;
        Preconditions.checkNotNull(tag);
        Preconditions.checkArgument(!tag.isEmpty());
        try {
            this.generationManager.appendUserTag(userID, tag, value, bulk);
        }
        catch (IOException ioe) {
            log.warn("Could not append datum; continuing", ioe);
        }
        try {
            generation = this.getCurrentGeneration();
        }
        catch (NotReadyException nre) {
            return;
        }
        long tagID = this.tagHasher.toLongID(tag);
        FastIDSet userTagIDs = generation.getUserTagIDs();
        Lock userTagWriteLock = generation.getYLock().writeLock();
        userTagWriteLock.lock();
        try {
            userTagIDs.add(tagID);
        }
        finally {
            userTagWriteLock.unlock();
        }
        float[] userFeatures = ServerRecommender.getFeatures(userID, generation.getX(), generation.getXLock());
        float[] tagFeatures = ServerRecommender.getFeatures(tagID, generation.getY(), generation.getYLock());
        ServerRecommender.updateFeatures(userFeatures, tagFeatures, value, generation);
        ServerRecommender.updateClusters(userID, userFeatures, generation.getUserClusters(), generation.getUserClustersLock().readLock());
    }

    @Override
    public void setItemTag(String tag, long itemID) {
        this.setItemTag(tag, itemID, 1.0f);
    }

    @Override
    public void setItemTag(String tag, long itemID, float value) {
        this.setItemTag(tag, itemID, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemTag(String tag, long itemID, float value, boolean bulk) {
        Generation generation;
        Preconditions.checkNotNull(tag);
        Preconditions.checkArgument(!tag.isEmpty());
        try {
            this.generationManager.appendItemTag(tag, itemID, value, bulk);
        }
        catch (IOException ioe) {
            log.warn("Could not append datum; continuing", ioe);
        }
        try {
            generation = this.getCurrentGeneration();
        }
        catch (NotReadyException nre) {
            return;
        }
        long tagID = this.tagHasher.toLongID(tag);
        FastIDSet itemTagIDs = generation.getItemTagIDs();
        Lock itemTagWriteLock = generation.getXLock().writeLock();
        itemTagWriteLock.lock();
        try {
            itemTagIDs.add(tagID);
        }
        finally {
            itemTagWriteLock.unlock();
        }
        float[] tagFeatures = ServerRecommender.getFeatures(tagID, generation.getX(), generation.getXLock());
        float[] itemFeatures = ServerRecommender.getFeatures(itemID, generation.getY(), generation.getYLock());
        ServerRecommender.updateFeatures(tagFeatures, itemFeatures, value, generation);
        ServerRecommender.updateClusters(itemID, itemFeatures, generation.getItemClusters(), generation.getItemClustersLock().readLock());
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany) throws NoSuchItemException, NotReadyException {
        return this.mostSimilarItems(itemID, howMany, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany, Rescorer<LongPair> rescorer) throws NoSuchItemException, NotReadyException {
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> Y = generation.getY();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            float[] itemFeatures = Y.get(itemID);
            if (itemFeatures == null) {
                throw new NoSuchItemException(itemID);
            }
            List<RecommendedItem> list = TopN.selectTopN(new MostSimilarItemIterator(Y.entrySet().iterator(), generation.getUserTagIDs(), new long[]{itemID}, new float[][]{itemFeatures}, rescorer), howMany);
            return list;
        }
        finally {
            yLock.unlock();
        }
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany) throws NoSuchItemException, NotReadyException {
        return this.mostSimilarItems(itemIDs, howMany, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer) throws NoSuchItemException, NotReadyException {
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> Y = generation.getY();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            ArrayList<float[]> itemFeatures = Lists.newArrayListWithCapacity(itemIDs.length);
            for (long itemID : itemIDs) {
                float[] features = Y.get(itemID);
                if (features == null) continue;
                itemFeatures.add(features);
            }
            if (itemFeatures.isEmpty()) {
                throw new NoSuchItemException(Arrays.toString(itemIDs));
            }
            float[][] itemFeaturesArray = (float[][])itemFeatures.toArray((T[])new float[itemFeatures.size()][]);
            List<RecommendedItem> list = TopN.selectTopN(new MostSimilarItemIterator(Y.entrySet().iterator(), generation.getUserTagIDs(), itemIDs, itemFeaturesArray, rescorer), howMany);
            return list;
        }
        finally {
            yLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] similarityToItem(long toItemID, long ... itemIDs) throws TasteException {
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<float[]> Y = generation.getY();
        float[] similarities = new float[itemIDs.length];
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            float[] toFeatures = Y.get(toItemID);
            if (toFeatures == null) {
                throw new NoSuchItemException(toItemID);
            }
            double toFeaturesNorm = SimpleVectorMath.norm(toFeatures);
            boolean anyFound = false;
            for (int i = 0; i < similarities.length; ++i) {
                float[] features = Y.get(itemIDs[i]);
                if (features == null) {
                    similarities[i] = Float.NaN;
                    continue;
                }
                anyFound = true;
                double featuresNorm = SimpleVectorMath.norm(features);
                similarities[i] = (float)(SimpleVectorMath.dot(features, toFeatures) / (featuresNorm * toFeaturesNorm));
            }
            if (!anyFound) {
                throw new NoSuchItemException(Arrays.toString(itemIDs));
            }
        }
        finally {
            yLock.unlock();
        }
        return similarities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> recommendedBecause(long userID, long itemID, int howMany) throws NoSuchUserException, NoSuchItemException, NotReadyException {
        FastIDSet userKnownItemIDs;
        Preconditions.checkArgument(howMany > 0, "howMany must be positive");
        Generation generation = this.getCurrentGeneration();
        FastByIDMap<FastIDSet> knownItemIDs = generation.getKnownItemIDs();
        if (knownItemIDs == null) {
            throw new UnsupportedOperationException("No known item IDs available");
        }
        Lock knownItemLock = generation.getKnownItemLock().readLock();
        knownItemLock.lock();
        try {
            userKnownItemIDs = knownItemIDs.get(userID);
        }
        finally {
            knownItemLock.unlock();
        }
        if (userKnownItemIDs == null) {
            throw new NoSuchUserException(userID);
        }
        FastByIDMap<float[]> Y = generation.getY();
        Lock yLock = generation.getYLock().readLock();
        yLock.lock();
        try {
            FastByIDMap<float[]> toFeatures;
            float[] features = Y.get(itemID);
            if (features == null) {
                throw new NoSuchItemException(itemID);
            }
            Iterable<Long> iterable = userKnownItemIDs;
            synchronized (iterable) {
                toFeatures = new FastByIDMap<float[]>(userKnownItemIDs.size(), 1.25f);
                LongPrimitiveIterator it = userKnownItemIDs.iterator();
                while (it.hasNext()) {
                    long fromItemID = it.nextLong();
                    float[] fromFeatures = Y.get(fromItemID);
                    toFeatures.put(fromItemID, fromFeatures);
                }
            }
            iterable = TopN.selectTopN(new RecommendedBecauseIterator(toFeatures.entrySet().iterator(), generation.getUserTagIDs(), features), howMany);
            return iterable;
        }
        finally {
            yLock.unlock();
        }
    }

    @Override
    public boolean isReady() {
        try {
            this.getCurrentGeneration();
            return true;
        }
        catch (NotReadyException ignored) {
            return false;
        }
    }

    @Override
    public void await() throws InterruptedException {
        while (!this.isReady()) {
            Thread.sleep(1000L);
        }
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        Preconditions.checkArgument(time >= 0L, "time must be positive: {}", time);
        Preconditions.checkNotNull(unit);
        long waitForMS = TimeUnit.MILLISECONDS.convert(time, unit);
        long waitIntervalMS = FastMath.min(1000L, waitForMS);
        long waitUntil = System.currentTimeMillis() + waitForMS;
        while (!this.isReady()) {
            if (System.currentTimeMillis() > waitUntil) {
                return false;
            }
            Thread.sleep(waitIntervalMS);
        }
        return true;
    }

    @Override
    public FastIDSet getAllUserIDs() throws NotReadyException {
        Generation generation = this.getCurrentGeneration();
        return ServerRecommender.getIDsFromKeys(generation.getX(), generation.getXLock().readLock(), generation.getItemTagIDs());
    }

    @Override
    public FastIDSet getAllItemIDs() throws NotReadyException {
        Generation generation = this.getCurrentGeneration();
        return ServerRecommender.getIDsFromKeys(generation.getY(), generation.getYLock().readLock(), generation.getUserTagIDs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FastIDSet getIDsFromKeys(FastByIDMap<float[]> map, Lock readLock, FastIDSet tagIDs) {
        readLock.lock();
        try {
            FastIDSet ids = new FastIDSet(map.size(), 1.25f);
            LongPrimitiveIterator it = map.keySetIterator();
            while (it.hasNext()) {
                long id = it.nextLong();
                if (tagIDs.contains(id)) continue;
                ids.add(id);
            }
            FastIDSet fastIDSet = ids;
            return fastIDSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumUserClusters() throws NotReadyException {
        Generation generation = this.getCurrentGeneration();
        List<IDCluster> clusters = generation.getUserClusters();
        if (clusters == null || clusters.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Lock lock = generation.getUserClustersLock().readLock();
        lock.lock();
        try {
            int n = clusters.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumItemClusters() throws NotReadyException {
        Generation generation = this.getCurrentGeneration();
        List<IDCluster> clusters = generation.getItemClusters();
        if (clusters == null || clusters.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Lock lock = generation.getItemClustersLock().readLock();
        lock.lock();
        try {
            int n = clusters.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastIDSet getUserCluster(int n) throws NotReadyException {
        FastIDSet members;
        Generation generation = this.getCurrentGeneration();
        List<IDCluster> clusters = generation.getUserClusters();
        if (clusters == null || clusters.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Lock lock = generation.getUserClustersLock().readLock();
        lock.lock();
        try {
            members = clusters.get(n).getMembers();
        }
        finally {
            lock.unlock();
        }
        FastIDSet fastIDSet = members;
        synchronized (fastIDSet) {
            return members.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastIDSet getItemCluster(int n) throws NotReadyException {
        FastIDSet members;
        Generation generation = this.getCurrentGeneration();
        List<IDCluster> clusters = generation.getItemClusters();
        if (clusters == null || clusters.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Lock lock = generation.getItemClustersLock().readLock();
        lock.lock();
        try {
            members = clusters.get(n).getMembers();
        }
        finally {
            lock.unlock();
        }
        FastIDSet fastIDSet = members;
        synchronized (fastIDSet) {
            return members.clone();
        }
    }

    @Override
    @Deprecated
    public DataModel getDataModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, boolean excludeItemIfNotSimilarToAll) throws NoSuchItemException, NotReadyException {
        if (excludeItemIfNotSimilarToAll) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    @Override
    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer, boolean excludeItemIfNotSimilarToAll) throws NoSuchItemException, NotReadyException {
        if (excludeItemIfNotSimilarToAll) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }
}

