/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import java.util.Iterator;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MutableRecommendedItem;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.SimpleVectorMath;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

final class RecommendedBecauseIterator
implements Iterator<RecommendedItem> {
    private final MutableRecommendedItem delegate = new MutableRecommendedItem();
    private final float[] features;
    private final double featuresNorm;
    private final Iterator<FastByIDMap.MapEntry<float[]>> toFeaturesIterator;
    private final FastIDSet userTagIDs;

    RecommendedBecauseIterator(Iterator<FastByIDMap.MapEntry<float[]>> toFeaturesIterator, FastIDSet userTagIDs, float[] features) {
        this.features = features;
        this.featuresNorm = SimpleVectorMath.norm(features);
        this.toFeaturesIterator = toFeaturesIterator;
        this.userTagIDs = userTagIDs;
    }

    @Override
    public boolean hasNext() {
        return this.toFeaturesIterator.hasNext();
    }

    @Override
    public RecommendedItem next() {
        FastByIDMap.MapEntry<float[]> entry = this.toFeaturesIterator.next();
        long itemID = entry.getKey();
        if (this.userTagIDs.contains(itemID)) {
            return null;
        }
        float[] candidateFeatures = entry.getValue();
        double candidateFeaturesNorm = SimpleVectorMath.norm(candidateFeatures);
        double estimate = SimpleVectorMath.dot(candidateFeatures, this.features) / (candidateFeaturesNorm * this.featuresNorm);
        if (!LangUtils.isFinite(estimate)) {
            return null;
        }
        this.delegate.set(itemID, (float)estimate);
        return this.delegate;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

