/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.common.RandomUtils;

public final class FastIDSet
implements Serializable,
Cloneable,
Iterable<Long> {
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private static final long REMOVED = Long.MAX_VALUE;
    private static final long NULL = Long.MIN_VALUE;
    private long[] keys;
    private float loadFactor;
    private int numEntries;
    private int numSlotsUsed;

    public FastIDSet() {
        this(2);
    }

    public FastIDSet(long[] initialKeys) {
        this(initialKeys.length);
        this.addAll(initialKeys);
    }

    public FastIDSet(int size) {
        this(size, 1.5f);
    }

    public FastIDSet(int size, float loadFactor) {
        Preconditions.checkArgument(size >= 0, "size must be at least 0");
        Preconditions.checkArgument(loadFactor >= 1.0f, "loadFactor must be at least 1.0");
        this.loadFactor = loadFactor;
        int max = (int)(2.147483E9f / loadFactor);
        Preconditions.checkArgument(size < max, "size must be less than %d", max);
        int hashSize = RandomUtils.nextTwinPrime((int)((int)(loadFactor * (float)size)));
        this.keys = new long[hashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    private int find(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && key != currentKey) {
            index = index < jump ? (index += hashSize - jump) : (index -= jump);
            currentKey = keys[index];
        }
        return index;
    }

    private int findForAdd(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && currentKey != Long.MAX_VALUE && key != currentKey) {
            index = index < jump ? (index += hashSize - jump) : (index -= jump);
            currentKey = keys[index];
        }
        return index;
    }

    public int size() {
        return this.numEntries;
    }

    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    public boolean contains(long key) {
        return key != Long.MIN_VALUE && key != Long.MAX_VALUE && this.keys[this.find(key)] != Long.MIN_VALUE;
    }

    public boolean add(long key) {
        int index;
        long keyIndex;
        Preconditions.checkArgument(key != Long.MIN_VALUE && key != Long.MAX_VALUE);
        if ((float)this.numSlotsUsed * this.loadFactor >= (float)this.keys.length) {
            if ((float)this.numEntries * this.loadFactor >= (float)this.numSlotsUsed) {
                this.growAndRehash();
            } else {
                this.rehash();
            }
        }
        if ((keyIndex = this.keys[index = this.findForAdd(key)]) != key) {
            this.keys[index] = key;
            ++this.numEntries;
            if (keyIndex == Long.MIN_VALUE) {
                ++this.numSlotsUsed;
            }
            return true;
        }
        return false;
    }

    public LongPrimitiveIterator iterator() {
        return new KeyIterator();
    }

    public long[] toArray() {
        long[] result = new long[this.numEntries];
        int position = 0;
        for (int i = 0; i < result.length; ++i) {
            while (this.keys[position] == Long.MIN_VALUE || this.keys[position] == Long.MAX_VALUE) {
                ++position;
            }
            result[i] = this.keys[position++];
        }
        return result;
    }

    public boolean remove(long key) {
        if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) {
            return false;
        }
        int index = this.find(key);
        if (this.keys[index] == Long.MIN_VALUE) {
            return false;
        }
        this.keys[index] = Long.MAX_VALUE;
        --this.numEntries;
        return true;
    }

    public boolean addAll(long[] c) {
        boolean changed = false;
        for (long k : c) {
            if (!this.add(k)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean addAll(FastIDSet c) {
        boolean changed = false;
        for (long k : c.keys) {
            if (k == Long.MIN_VALUE || k == Long.MAX_VALUE || !this.add(k)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(long[] c) {
        boolean changed = false;
        for (long o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(FastIDSet c) {
        boolean changed = false;
        for (long k : c.keys) {
            if (k == Long.MIN_VALUE || k == Long.MAX_VALUE || !this.remove(k)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(FastIDSet c) {
        boolean changed = false;
        for (int i = 0; i < this.keys.length; ++i) {
            long k = this.keys[i];
            if (k == Long.MIN_VALUE || k == Long.MAX_VALUE || c.contains(k)) continue;
            this.keys[i] = Long.MAX_VALUE;
            --this.numEntries;
            changed = true;
        }
        return changed;
    }

    public void clear() {
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    private void growAndRehash() {
        if ((float)this.keys.length * this.loadFactor >= 2.147483E9f) {
            throw new IllegalStateException("Can't grow any more");
        }
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(this.loadFactor * (float)this.keys.length))));
    }

    public void rehash() {
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(this.loadFactor * (float)this.numEntries))));
    }

    private void rehash(int newHashSize) {
        long[] oldKeys = this.keys;
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        this.keys = new long[newHashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        for (long key : oldKeys) {
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            this.add(key);
        }
    }

    public int intersectionSize(FastIDSet other) {
        int count = 0;
        for (long key : other.keys) {
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE || this.keys[this.find(key)] == Long.MIN_VALUE) continue;
            ++count;
        }
        return count;
    }

    public FastIDSet clone() {
        FastIDSet clone;
        try {
            clone = (FastIDSet)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError();
        }
        clone.keys = (long[])this.keys.clone();
        return clone;
    }

    public int hashCode() {
        int hash = 0;
        for (long key : this.keys) {
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            hash = 31 * hash + ((int)(key >> 32) ^ (int)key);
        }
        return hash;
    }

    public boolean equals(Object other) {
        long key;
        int i;
        if (!(other instanceof FastIDSet)) {
            return false;
        }
        FastIDSet otherMap = (FastIDSet)other;
        long[] otherKeys = otherMap.keys;
        int length = this.keys.length;
        int otherLength = otherKeys.length;
        int max = Math.min(length, otherLength);
        for (i = 0; i < max; ++i) {
            key = this.keys[i];
            long otherKey = otherKeys[i];
            if (!(key == Long.MIN_VALUE || key == Long.MAX_VALUE ? otherKey != Long.MIN_VALUE && otherKey != Long.MAX_VALUE : key != otherKey)) continue;
            return false;
        }
        while (i < length) {
            key = this.keys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        while (i < otherLength) {
            key = otherKeys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (long key : this.keys) {
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            result.append(key).append(',');
        }
        result.setCharAt(result.length() - 1, ']');
        return result.toString();
    }

    private final class KeyIterator
    extends AbstractLongPrimitiveIterator {
        private int position;
        private int lastNext = -1;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goToNext();
            return this.position < FastIDSet.this.keys.length;
        }

        @Override
        public long nextLong() {
            this.goToNext();
            this.lastNext = this.position;
            if (this.position >= FastIDSet.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastIDSet.this.keys[this.position++];
        }

        @Override
        public long peek() {
            this.goToNext();
            if (this.position >= FastIDSet.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastIDSet.this.keys[this.position];
        }

        private void goToNext() {
            int length = FastIDSet.this.keys.length;
            while (this.position < length && (FastIDSet.this.keys[this.position] == Long.MIN_VALUE || FastIDSet.this.keys[this.position] == Long.MAX_VALUE)) {
                ++this.position;
            }
        }

        @Override
        public void remove() {
            if (this.lastNext >= FastIDSet.this.keys.length) {
                throw new NoSuchElementException();
            }
            if (this.lastNext < 0) {
                throw new IllegalStateException();
            }
            ((FastIDSet)FastIDSet.this).keys[this.lastNext] = Long.MAX_VALUE;
            FastIDSet.this.numEntries--;
        }

        public Iterator<Long> iterator() {
            return new KeyIterator();
        }

        @Override
        public void skip(int n) {
            this.position += n;
        }
    }
}

