/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import net.myrrix.common.math.Solver;
import org.apache.commons.math3.linear.RealMatrix;

final class InverseBasedSolver
implements Solver {
    private final RealMatrix Ainv;

    InverseBasedSolver(RealMatrix Ainv) {
        this.Ainv = Ainv;
    }

    @Override
    public float[] solveDToF(double[] b) {
        double[] x = this.Ainv.operate(b);
        float[] xCopy = new float[x.length];
        for (int i = 0; i < xCopy.length; ++i) {
            xCopy[i] = (float)x[i];
        }
        return xCopy;
    }

    @Override
    public double[] solveFToD(float[] b) {
        double[] bCopy = new double[b.length];
        for (int i = 0; i < bCopy.length; ++i) {
            bCopy[i] = b[i];
        }
        return this.Ainv.operate(bCopy);
    }
}

