/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Vector;

public class ManhattanDistanceMeasure
implements DistanceMeasure {
    public static double distance(double[] p1, double[] p2) {
        double result = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            result += Math.abs(p2[i] - p1[i]);
        }
        return result;
    }

    @Override
    public void configure(Configuration job) {
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    @Override
    public double distance(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new CardinalityException(v1.size(), v2.size());
        }
        double result = 0.0;
        Vector vector = v1.minus(v2);
        Iterator iter = vector.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = (Vector.Element)iter.next();
            result += Math.abs(e.get());
        }
        return result;
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }
}

