/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import com.google.common.io.Closeables;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.als.ALSUtils;
import org.apache.mahout.cf.taste.hadoop.als.RecommenderJob;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class FactorizationEvaluator
extends AbstractJob {
    private static final String USER_FEATURES_PATH = RecommenderJob.class.getName() + ".userFeatures";
    private static final String ITEM_FEATURES_PATH = RecommenderJob.class.getName() + ".itemFeatures";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new FactorizationEvaluator(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOption("userFeatures", null, "path to the user feature matrix", true);
        this.addOption("itemFeatures", null, "path to the item feature matrix", true);
        this.addOutputOption();
        Map<String, List<String>> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path errors = this.getTempPath("errors");
        Job predictRatings = this.prepareJob(this.getInputPath(), errors, TextInputFormat.class, PredictRatingsMapper.class, DoubleWritable.class, NullWritable.class, SequenceFileOutputFormat.class);
        predictRatings.getConfiguration().set(USER_FEATURES_PATH, this.getOption("userFeatures"));
        predictRatings.getConfiguration().set(ITEM_FEATURES_PATH, this.getOption("itemFeatures"));
        boolean succeeded = predictRatings.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        BufferedWriter writer = null;
        try {
            FileSystem fs = FileSystem.get((URI)this.getOutputPath().toUri(), (Configuration)this.getConf());
            FSDataOutputStream outputStream = fs.create(this.getOutputPath("rmse.txt"));
            double rmse = this.computeRmse(errors);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream));
            writer.write(String.valueOf(rmse));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly(writer);
        return 0;
    }

    protected double computeRmse(Path errors) {
        FullRunningAverage average = new FullRunningAverage();
        for (Pair entry : new SequenceFileDirIterable(errors, PathType.LIST, PathFilters.logsCRCFilter(), this.getConf())) {
            DoubleWritable error = (DoubleWritable)entry.getFirst();
            average.addDatum(error.get() * error.get());
        }
        return Math.sqrt(average.getAverage());
    }

    public static class PredictRatingsMapper
    extends Mapper<LongWritable, Text, DoubleWritable, NullWritable> {
        private OpenIntObjectHashMap<Vector> U;
        private OpenIntObjectHashMap<Vector> M;

        protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
            Path pathToU = new Path(ctx.getConfiguration().get(USER_FEATURES_PATH));
            Path pathToM = new Path(ctx.getConfiguration().get(ITEM_FEATURES_PATH));
            this.U = ALSUtils.readMatrixByRows(pathToU, ctx.getConfiguration());
            this.M = ALSUtils.readMatrixByRows(pathToM, ctx.getConfiguration());
        }

        protected void map(LongWritable key, Text value, Mapper.Context ctx) throws IOException, InterruptedException {
            String[] tokens = TasteHadoopUtils.splitPrefTokens(value.toString());
            int userID = Integer.parseInt(tokens[0]);
            int itemID = Integer.parseInt(tokens[1]);
            double rating = Double.parseDouble(tokens[2]);
            if (this.U.containsKey(userID) && this.M.containsKey(itemID)) {
                double estimate = ((Vector)this.U.get(userID)).dot((Vector)this.M.get(itemID));
                double err = rating - estimate;
                ctx.write((Object)new DoubleWritable(err), (Object)NullWritable.get());
            }
        }
    }
}

