/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.common.random.RandomManager;
import net.myrrix.common.random.RandomUtils;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.eval.AbstractEvaluator;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.EvaluationResultImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AUCEvaluator
extends AbstractEvaluator {
    private static final Logger log = LoggerFactory.getLogger(AUCEvaluator.class);

    @Override
    protected boolean isSplitTestByPrefValue() {
        return true;
    }

    @Override
    public EvaluationResult evaluate(MyrrixRecommender recommender, RescorerProvider provider, Multimap<Long, RecommendedItem> testData) throws TasteException {
        FastByIDMap<FastIDSet> converted = new FastByIDMap<FastIDSet>(testData.size(), 1.25f);
        for (long userID : testData.keySet()) {
            Collection<RecommendedItem> userTestData = testData.get(userID);
            FastIDSet itemIDs = new FastIDSet(userTestData.size(), 1.25f);
            converted.put(userID, itemIDs);
            for (RecommendedItem datum : userTestData) {
                itemIDs.add(datum.getItemID());
            }
        }
        return this.evaluate(recommender, converted);
    }

    public EvaluationResult evaluate(final MyrrixRecommender recommender, final FastByIDMap<FastIDSet> testData) throws TasteException {
        final AtomicInteger underCurve = new AtomicInteger(0);
        final AtomicInteger total = new AtomicInteger(0);
        final long[] allItemIDs = recommender.getAllItemIDs().toArray();
        Processor<Long> processor = new Processor<Long>(){
            private final RandomGenerator random = RandomManager.getRandom();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Long userID, long count) throws ExecutionException {
                FastIDSet testItemIDs = (FastIDSet)testData.get(userID);
                int numTest = testItemIDs.size();
                for (int i = 0; i < numTest; ++i) {
                    float nonRelevantEstimate;
                    float relevantEstimate;
                    long randomTrainingItemID;
                    long randomTestItemID;
                    RandomGenerator randomGenerator = this.random;
                    synchronized (randomGenerator) {
                        randomTestItemID = RandomUtils.randomFrom(testItemIDs, this.random);
                        while (testItemIDs.contains(randomTrainingItemID = allItemIDs[this.random.nextInt(allItemIDs.length)])) {
                        }
                    }
                    try {
                        relevantEstimate = recommender.estimatePreference(userID, randomTestItemID);
                        nonRelevantEstimate = recommender.estimatePreference(userID, randomTrainingItemID);
                    }
                    catch (NoSuchItemException nsie) {
                        continue;
                    }
                    catch (NoSuchUserException nsie) {
                        continue;
                    }
                    catch (TasteException te) {
                        throw new ExecutionException(te);
                    }
                    if (relevantEstimate > nonRelevantEstimate) {
                        underCurve.incrementAndGet();
                    }
                    total.incrementAndGet();
                    if (count % 100000L != 0L) continue;
                    log.info("AUC: {}", (Object)((double)underCurve.get() / (double)total.get()));
                }
            }
        };
        try {
            new Paralleler<Long>(testData.keySetIterator(), processor, "AUCEval").runInParallel();
        }
        catch (InterruptedException ie) {
            throw new TasteException(ie);
        }
        catch (ExecutionException e) {
            throw new TasteException(e.getCause());
        }
        double score = (double)underCurve.get() / (double)total.get();
        log.info("AUC: {}", (Object)score);
        return new EvaluationResultImpl(score);
    }

    public static void main(String[] args) throws Exception {
        AUCEvaluator eval = new AUCEvaluator();
        EvaluationResult result = eval.evaluate(new File(args[0]));
        log.info(result.toString());
    }
}

