/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MutableRecommendedItem;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.SimpleVectorMath;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

final class RecommendIterator
implements Iterator<RecommendedItem> {
    private final MutableRecommendedItem delegate;
    private final float[][] features;
    private final Iterator<FastByIDMap.MapEntry<float[]>> Yiterator;
    private final FastIDSet knownItemIDs;
    private final FastIDSet userTagIDs;
    private final IDRescorer rescorer;

    RecommendIterator(float[][] features, Iterator<FastByIDMap.MapEntry<float[]>> Yiterator, FastIDSet knownItemIDs, FastIDSet userTagIDs, IDRescorer rescorer) {
        Preconditions.checkArgument(features.length > 0, "features must not be empty");
        this.delegate = new MutableRecommendedItem();
        this.features = features;
        this.Yiterator = Yiterator;
        this.knownItemIDs = knownItemIDs;
        this.userTagIDs = userTagIDs;
        this.rescorer = rescorer;
    }

    @Override
    public boolean hasNext() {
        return this.Yiterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecommendedItem next() {
        IDRescorer rescorer;
        FastByIDMap.MapEntry<float[]> entry = this.Yiterator.next();
        long itemID = entry.getKey();
        if (this.userTagIDs.contains(itemID)) {
            return null;
        }
        FastIDSet theKnownItemIDs = this.knownItemIDs;
        if (theKnownItemIDs != null) {
            FastIDSet fastIDSet = theKnownItemIDs;
            synchronized (fastIDSet) {
                if (theKnownItemIDs.contains(itemID)) {
                    return null;
                }
            }
        }
        if ((rescorer = this.rescorer) != null && rescorer.isFiltered(itemID)) {
            return null;
        }
        float[] itemFeatures = entry.getValue();
        double sum = 0.0;
        int count = 0;
        for (float[] oneUserFeatures : this.features) {
            sum += SimpleVectorMath.dot(itemFeatures, oneUserFeatures);
            ++count;
        }
        if (rescorer != null && !LangUtils.isFinite(sum = rescorer.rescore(itemID, sum))) {
            return null;
        }
        float result = (float)(sum / (double)count);
        Preconditions.checkState(LangUtils.isFinite(result), "Bad recommendation value");
        this.delegate.set(itemID, result);
        return this.delegate;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

