% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multi_D_mod.R
\name{Multi_D_mod}
\alias{Multi_D_mod}
\title{Information Gain}
\usage{
Multi_D_mod(y, V_inv, Command)
}
\arguments{
\item{y}{Output Features for the samples of the node}

\item{V_inv}{Covariance matrix of Output Feature matrix}

\item{Command}{1 for RF and 2 for MRF depending on the method}
}
\value{
cost or Entropy of samples in a node of a tree
}
\description{
Compute the cost function of a node of samples in a tree
}
\details{
In multivariate trees(MRF) node cost is measured as the sum of squares of the Mahalanobis 
distance to capture the correlations in the data where in univariate trees node cost is measured as the Euclidean distance. 
Mahalanobis Distance captures the distance of the sample point from the mean of the node along the principal component axes.
}
\examples{
y=matrix(runif(10*2),10,2)
V_inv=stats::cov(y)
Command=2
#Command=2 for MRF and 1 for RF
#This function calculates information gain of a node
Cost=Multi_D_mod(y,V_inv,Command)
}
\references{
De Maesschalck, Roy, Delphine Jouan-Rimbaud, and Desire L. Massart. "The mahalanobis distance." Chemometrics and intelligent laboratory systems 50.1 (2000): 1-18.
}

