% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BADF.R
\name{badf}
\alias{badf}
\title{Backward Augmented Dickey-Fuller Sequence.}
\usage{
badf(m, t, adflag = 0, mflag = 1)
}
\arguments{
\item{m}{Number of Monte Carlo replications. Must be bigger than 2.}

\item{t}{Sample size. Must be bigger than 2.}

\item{adflag}{Number of lags to be included in the ADF Test. Default equals 0.}

\item{mflag}{1 for ADF with constant and whithout trend, 2 for ADF with constant and trend and 3 for ADF without constant and trend.}
}
\description{
In this program, we calculate critical value sequences for the backward ADF statistic
sequence for a matrix generated from a standard Normal distribution.
}
\examples{
foo <- badf(m = 100, t = 50, adflag = 1, mflag = 1)
plot(foo$quantiles[2,], type = 'l')
}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2015a). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
\keyword{AugmentedDickey-FullerTest}
\keyword{BackwardADFSequence}
\keyword{MonteCarlo.}
