% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{EVSKSkewNorm}
\alias{EVSKSkewNorm}
\title{EVSK multivariate Skew Normal}
\usage{
EVSKSkewNorm(omega, alpha)
}
\arguments{
\item{omega}{A \eqn{d \times d} correlation matrix}

\item{alpha}{shape parameter d-vector}
}
\value{
A list of theoretical values for the mean vector,  covariance, skewness vector,
total skenwness, kurtosis vector and total kurtosis
}
\description{
Computes the theoretical values of the mean vector,  covariance, skewness vector,
total skenwness, kurtosis vector and total
kurtosis for the multivariate Skew Normal distribution
}
\examples{
alpha<-c(10,5,0)
omega<-diag(3)
EVSKSkewNorm(omega,alpha)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (5.5) p.247

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
