% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{NumOutputs}
\alias{NumOutputs}
\title{Construct the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, and GFEVDs)}
\usage{
NumOutputs(ModelType, ModelPara, InputsForOutputs, FactorLabels, Economies)
}
\arguments{
\item{ModelType}{a string-vector containing the label of the model to be estimated}

\item{ModelPara}{List of model parameter estimates (See the "Optimization" function)}

\item{InputsForOutputs}{list conataining the desired horizon of analysis for the model fit, IRFs, GIRFs, FEVDs, and GFEVDs}

\item{FactorLabels}{a string-list based which contains all the labels of all the variables present in the model}

\item{Economies}{a string-vector containing the names of the economies which are part of the economic system}
}
\value{
List of the model numerical outputs, namely
\enumerate{
\item Model fit of bond yields
\item IRFs
\item FEVDs
\item GIRFs
\item GFEVDs
}
}
\description{
Construct the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, and GFEVDs)
}
\examples{
# See examples in the vignette file of this package (Section 4).


}
