\name{write.PG.file.all}
\alias{write.PG.file.all}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Writes a file with the bin codes with one column per allele }
\description{
  Writes a file in the working directory. Uses the information on the database to write a
    file in the appropriate format for  most population genetics analysis software. The output
  format has one allele per column.
}
\usage{
write.PG.file.all(DB, refDB = DB, outfile = "Population genetics file.txt")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
   \item{DB}{ A data base of the type used by this package, like the generated by \code{\link{transDB}} 
  function}
  \item{refDB}{ A larger data set for optimal reference during the allele coding} 
  \item{outfile}{ A name for the output file} 
}
\details{
  The algorithm implemented searchs the database for all observed fragments within the interval set by
   -0.8 to + 0.8 bp of the fragment. It proceeds to detect breaks in the distribution of observed distribution
   to find the distribution where the fragment belongs. To get the allele code the median of that distribution
  is rounded to an integer value.
}
\value{
  A table is written into the working directory (.PG.txt file) with the first column having the sample names and every
  subsquent column the information for alleles. Alleles of a locus are given in two columns. There is also a file written
  with the counts for the number of fragments for each combination  of locus and sample (AC.txt file), remember that 
  there should be only a maximum of 2 for this value, otherwise the code will write the first two fragments scored to 
  build the genotype
  
}
\author{ Filipe Alberto}
\references{
 Alberto F. MsatAllele_1.0: an R package to visualize the binning of microsatellite alleles Journal of Heredity. 100(3):394,397
}
\seealso{ \code{\link{write.PG.file.loc}}, \code{\link{read.ah.file}} }
\examples{data(DBase)
	write.PG.file.all(DBase)
}

\keyword{ IO }
