% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHMD.R
\name{ReadHMD}
\alias{ReadHMD}
\title{Download Mortality and Population Data (HMD)}
\usage{
ReadHMD(what, countries = NULL, interval = "1x1", username, password,
  save = FALSE, show = TRUE)
}
\arguments{
\item{what}{What type of data are you looking for? The following options are 
available: \itemize{
  \item{\code{"births"}} -- birth records;
  \item{\code{"Dx_lexis"}} -- deaths by Lexis triangles;
  \item{\code{"Ex_lexis"}} -- exposure-to-risk by Lexis triangles;
  \item{\code{"population"}} -- population size;
  \item{\code{"Dx"}} -- death counts;
  \item{\code{"Ex"}} -- exposure-to-risk;
  \item{\code{"mx"}} -- central death-rates;
  \item{\code{"LT_f"}} -- period life tables for females;
  \item{\code{"LT_m"}} -- period life tables for males;
  \item{\code{"LT_t"}} -- period life tables both sexes combined;
  \item{\code{"e0"}} -- period life expectancy at birth;
  \item{\code{"Exc"}} -- cohort exposures;
  \item{\code{"mxc"}} -- cohort death-rates;
  \item{\code{"LT_fc"}} -- cohort life tables for females;
  \item{\code{"LT_mc"}} -- cohort life tables for males;
  \item{\code{"LT_tc"}} -- cohort life tables both sexes combined;
  \item{\code{"e0c"}} -- cohort life expectancy at birth;
  }}

\item{countries}{Specify the country data you want to download by adding the 
HMD country code/s. Options: 
\code{"AUS","AUT","BEL","BGR","BLR","CAN","CHL","CHE","CZE", "DEUTE",
"DEUTNP","DEUTW","DNK","ESP","EST","FIN","FRACNP","FRATNP","KOR","GBR_NIR",
"GBR_NP","GBR_SCO","GBRCENW","GBRTENW","GRC","HUN","HRV","IRL","ISL","ISR",
"ITA","JPN","LTU","LUX","LVA","NLD","NOR","NZL_MA","NZL_NM","NZL_NP","POL",
"PRT","RUS","SVK","SVN","SWE","TWN","USA","UKR"}.}

\item{interval}{HMD data format: (age interval x year interval).
Interval options: \code{1x1}, \code{1x5}, \code{1x10}, 
\code{5x1}, \code{5x5}, \code{5x10}.}

\item{username}{Your HMD username. If you don't have one you can sign up
for free on the Human Mortality Database website.}

\item{password}{Your HMD password.}

\item{save}{Do you want to save a copy of the dataset on your local machine? 
Logical. Default: \code{FALSE}.}

\item{show}{Choose whether to display a progress bar. Logical. 
Default: \code{TRUE}.}
}
\value{
A \code{ReadHMD} object that contains:
 \item{input}{List with the input values (except the password).}
 \item{data}{Data downloaded from HMD.}
 \item{download.date}{Time stamp.}
 \item{years}{Numerical vector with the years covered in the data.}
 \item{ages}{Numerical vector with ages covered in the data.}
}
\description{
Download detailed mortality and population data for different countries 
and regions in a single object from the \href{https://www.mortality.org}{
Human Mortality Database}.
}
\examples{
\dontrun{
# Download demographic data for 3 countries in 1x1 format 
age_int  <- 1  # age interval: 1,5
year_int <- 1  # year interval: 1,5,10
interval <- paste0(age_int, "x", year_int)  # --> 1x1
# And the 3 countries: Sweden Denmark and USA. We have to use the HMD codes
cntr  <- c('SWE', 'DNK', 'USA')  

# Download death counts. We don't want to export data outside R.
HMD_Dx <- ReadHMD(what = "Dx",
                  countries = cntr,
                  interval  = interval,
                  username  = "user@email.com",
                  password  = "password",
                  save = FALSE)
ls(HMD_Dx)
HMD_Dx

# Download life tables for female population and export data.
LTF <- ReadHMD(what = "LT_f",
               countries = cntr,
               interval  = interval,
               username  = "user@email.com",
               password  = "password",
               save = TRUE)
LTF
} 
}
\author{
Marius D. Pascariu
}
