% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LC.R
\name{rotate.leecarter}
\alias{rotate.leecarter}
\alias{ultimate.bx}
\title{Rotated Lee-Carter}
\usage{
rotate.leecarter(bx, ultimate.bx, e0, e0l = 80, e0u = 102, p = 0.5)

ultimate.bx(bx)
}
\arguments{
\item{bx}{A vector of the Lee-Carter \eqn{b_x} parameter
(from e.g. \code{\link{lileecarter.estimate}} or \code{\link{leecarter.estimate}}).}

\item{ultimate.bx}{A vector of the ultimate\eqn{b^u_x} parameter as defined in Li, Lee, Gerland (2013)
(obtained using \code{\link{lileecarter.estimate}} or \code{\link{ultimate.bx}}).}

\item{e0}{A time series of life expectancies.}

\item{e0l}{Level of life expectancy at which the rotation starts.}

\item{e0u}{Level of life expectancy at which the rotation finishes.}

\item{p}{Exponent of the smooth function.}
}
\value{
Function \code{rotate.leecarter} returns a matrix of rotated \eqn{B_x(t)} where rows correspond to age groups and columns 
   correspond to time periods (given by the vector \code{e0}).

Function \code{ultimate.bx} returns a vector of the ultimate \eqn{b^u_x}.
}
\description{
Rotate the Lee-Carter parameter \eqn{b_x} over time to reach an ultimate \eqn{b^u_x}, 
    as described in Li et al. (2013).
}
\examples{
data(mxF, mxM, e0Fproj, e0Mproj, package = "wpp2017")
country <- "Japan"
mxm <- subset(mxM, name == country)[,4:16]
mxf <- subset(mxF, name == country)[,4:16]
e0f <- as.numeric(subset(e0Fproj, name == country)[-(1:2)])
e0m <- as.numeric(subset(e0Mproj, name == country)[-(1:2)])
rownames(mxm) <- rownames(mxf) <- c(0,1, seq(5, 100, by=5))
lc <- lileecarter.estimate(mxm, mxf)
rotlc <- rotate.leecarter(lc$bx, lc$ultimate.bx, (e0f + e0m)/2)
plot(lc$bx, type="l")
lines(lc$ultimate.bx, col="red")
for(i in 1:ncol(rotlc)) lines(rotlc[,i], col="grey")
  
}
\references{
Li, N., Lee, R. D. and Gerland, P. (2013). Extending the Lee-Carter method to model the rotation 
of age patterns of mortality decline for long-term projections. Demography, 50, 2037-2051.
}
