% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls2B.r
\name{plsCoVarCommonShape}
\alias{plsCoVarCommonShape}
\title{Compute the shape changes along the common axis of deformations}
\usage{
plsCoVarCommonShape(pls, i, sdcommon = 1)
}
\arguments{
\item{pls}{object of class "pls2B"}

\item{i}{integer: dimension of latent space to show shape changes for}

\item{sdcommon}{standard deviations derived from scores scaled to a consensus scale}
}
\value{
returns an k x m x 2 array with the common shape changes associated with +-\code{sdcommon} SD of the \code{i-th} latent dimension
}
\description{
Compute the shape changes between two blocks of 2D or 3D shape coordiantes along the common axis of deformations defined by each dimension of the latent space
}
\note{
this give the same results as \code{plsCoVar}, however, using common shape vectors as suggested by Mitteroecker and Bookstein (2007)
}
\examples{
data(boneData)
proc <- procSym(boneLM)
pls <- pls2B(proc$orpdata[1:4,,],proc$orpdata[5:10,,])
commShape <- getPLSCommonShape(pls)
## get common shape for first latent dimension at +-2 sd of the scores
pred <- plsCoVarCommonShape(pls,1,2)
\dontrun{
deformGrid3d(pred[,,1],pred[,,2])
}
}
\references{
Mitteroecker P, Bookstein F. 2007. The conceptual and statistical relationship between modularity and morphological integration. Systematic Biology 56(5):818-836.
}
\seealso{
\code{\link{pls2B}, \link{getPLSfromScores}, \link{predictPLSfromScores}, \link{getPLSscores}, \link{predictPLSfromData},\link{svd},  \link{plsCoVar},  \link{getPLSCommonShape}}
}
