% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procSym.r
\name{align2procSym}
\alias{align2procSym}
\title{align new data to an existing Procrustes registration}
\usage{
align2procSym(x, newdata, orp = TRUE)
}
\arguments{
\item{x}{result of a \code{procSym} call}

\item{newdata}{matrix or array of with landmarks corresponding to the data aligned in x}

\item{orp}{logical: allows to skip orthogonal projection, even if it was used in the \code{procSym} call.}
}
\value{
an array with data aligned to the mean shape in x (and projected into tangent space)
}
\description{
align new data to an existing Procrustes registration
}
\note{
this will never yield the same result as a pooled Procrustes analysis because the sample mean is iteratively updated and new data would change the mean.
}
\examples{
require(Morpho)
data(boneData)
# run procSym on entire data set
proc <- procSym(boneLM)
# this is the training data
array1 <- boneLM[,,1:60]
newdata <- boneLM[,,61:80]
proc1 <- procSym(array1)
newalign <- align2procSym(proc1,newdata)
## compare alignment for one specimen to Proc. registration using all data
\dontrun{
deformGrid3d(newalign[,,1],proc$orpdata[,,61])
}
}
