% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-layers.R
\name{plot_PCA}
\alias{plot_PCA}
\title{PCA plot using grindr layers}
\usage{
plot_PCA(
  x,
  f = NULL,
  axes = c(1, 2),
  palette = NULL,
  points = TRUE,
  points_transp = 1/4,
  morphospace = TRUE,
  morphospace_position = "range",
  chull = TRUE,
  chullfilled = FALSE,
  labelpoints = FALSE,
  labelgroups = FALSE,
  legend = TRUE,
  title = "",
  center_origin = TRUE,
  zoom = 0.9,
  eigen = TRUE,
  box = TRUE,
  axesnames = TRUE,
  axesvar = TRUE
)
}
\arguments{
\item{x}{a \link{PCA} object}

\item{f}{factor specification to feed \link{fac_dispatcher}}

\item{axes}{\code{numeric} of length two to select PCs to use
(\code{c(1, 2)} by default)}

\item{palette}{\code{color palette} to use \code{col_summer} by default}

\item{points}{\code{logical} whether to draw this with \link{layer_points}}

\item{points_transp}{\code{numeric} to feed \link{layer_points} (default:0.25)}

\item{morphospace}{\code{logical} whether to draw this using \link{layer_morphospace_PCA}}

\item{morphospace_position}{to feed \link{layer_morphospace_PCA} (default: "range")}

\item{chull}{\code{logical} whether to draw this with \link{layer_chull}}

\item{chullfilled}{\code{logical} whether to draw this with \link{layer_chullfilled}}

\item{labelpoints}{\code{logical} whether to draw this with \link{layer_labelpoints}}

\item{labelgroups}{\code{logical} whether to draw this with \link{layer_labelgroups}}

\item{legend}{\code{logical} whether to draw this with \link{layer_legend}}

\item{title}{\code{character} if specified, fee \link{layer_title} (default to \code{""})}

\item{center_origin}{\code{logical} whether to center origin}

\item{zoom}{\code{numeric} zoom level for the frame (default: 0.9)}

\item{eigen}{\code{logical} whether to draw this using \link{layer_eigen}}

\item{box}{\code{logical} whether to draw this using \link{layer_box}}

\item{axesnames}{\code{logical} whether to draw this using \link{layer_axesnames}}

\item{axesvar}{\code{logical} whether to draw this using \link{layer_axesvar}}
}
\description{
Quickly vizualise \link{PCA} objects and friends and build customs plots
using the \link{layers}. See examples.
}
\note{
This approach will replace \link{plot.PCA} (and \code{plot.lda} in further versions.
This is part of \code{grindr} approach that may be packaged at some point. All comments are welcome.
}
\examples{
### First prepare two PCA objects.

# Some outlines with bot
bp <- bot \%>\% mutate(fake=sample(letters[1:5], 40, replace=TRUE)) \%>\%
efourier(6) \%>\% PCA
plot_PCA(bp)
plot_PCA(bp, ~type)
plot_PCA(bp, ~fake)

# Some curves with olea
op <- olea \%>\%
mutate(s=coo_area(.)) \%>\%
filter(var != "Cypre") \%>\%
chop(~view) \%>\% opoly(5, nb.pts=90) \%>\%
combine \%>\% PCA
op$fac$s \%<>\% as.character() \%>\% as.numeric()

op \%>\% plot_PCA(title="hi there!")

### Now we can play with layers
# and for instance build a custom plot
# it should start with plot_PCA()

my_plot <- function(x, ...){

x \%>\%
    plot_PCA(...) \%>\%
    layer_points \%>\%
    layer_ellipsesaxes \%>\%
    layer_rug
}

# and even continue after this function
op \%>\% my_plot(~var, axes=c(1, 3)) \%>\%
    layer_title("hi there!")

# grindr allows (almost nice) tricks like highlighting:

# bp \%>\% .layerize_PCA(~fake) \%>\%
#   layer_frame \%>\% layer_axes() \%>\%
#   layer_morphospace_PCA() -> x

# highlight <- function(x, ..., col_F="#CCCCCC", col_T="#FC8D62FF"){
#  args <- list(...)
#  x$colors_groups <- c(col_F, col_T)
#  x$colors_rows <- c(col_F, col_T)[(x$f \%in\% args)+1]
#  x
#  }
# x \%>\% highlight("a", "b") \%>\% layer_points()

# You get the idea.
}
\seealso{
Other grindr: 
\code{\link{drawers}},
\code{\link{layers_morphospace}},
\code{\link{layers}},
\code{\link{mosaic_engine}()},
\code{\link{papers}},
\code{\link{pile}()},
\code{\link{plot_LDA}()},
\code{\link{plot_NMDS}()}
}
\concept{grindr}
