% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{ntsrow2Coo}
\alias{ntsrow2Coo}
\alias{ntscol2Coo}
\title{Imports .nts to Coo objects}
\usage{
ntsrow2Coo(nts.path, sep = "\\t")
}
\arguments{
\item{nts.path}{the path to the .nts file}

\item{sep}{the separator between data}
}
\description{
Useful to convert .nts files into \link{Coo} objects. For .nts provided as rows, use
ntsrow2Coo; for .nts provided as columns of coordinates, try ntscol2Coo. It
returns a list of matrices of coordinates that can be passed to \link{Coo} (\link{Out}, \link{Opn} or \link{Ldk}).
}
\note{
I'm not very familiar to other morphometric formats.
So if you have troubles importing your datasets, contact me, I can help. Or if you fix something,
please let met know!
}
\examples{
# That's how wings dataset was created
# made a local copy from http://life.bio.sunysb.edu/morph/data/RohlfSlice1990Mosq.nts
# then :
# coo_list  <- ntscol2Coo('~/Desktop/mosquitowings.nts)
# fac       <- data.frame(fac=factor(substr(names(coo_list), 1, 2)))
# wings <- Ldk(coo_list, fac=fac)
}
\seealso{
Other babel functions: \code{\link{bind_db}},
  \code{\link{chc2Out}}, \code{\link{chc2pix}},
  \code{\link{import_StereoMorph_curve1}},
  \code{\link{import_jpg}}, \code{\link{import_tps}},
  \code{\link{nef2Coe}}, \code{\link{pix2chc}},
  \code{\link{tie_jpg_txt}}, \code{\link{tps2coo}}
}
