% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-outopn-calibrate.R
\name{calibrate_r2}
\alias{calibrate_r2}
\title{Quantitative r2 calibration for Opn objects}
\usage{
calibrate_r2(Opn, method = "opoly", id = 1:length(Opn),
  degree.range = 1:8, thresh = c(0.9, 0.95, 0.99, 0.999), plot = TRUE,
  verbose = TRUE, ...)
}
\arguments{
\item{Opn}{an Opn object}

\item{method}{one of 'npoly' or 'opoly'}

\item{id}{the ids of shapes on which to calculate r2 (all by default)}

\item{degree.range}{on which to calculate r2}

\item{thresh}{the threshold to return diagnostic}

\item{plot}{logical whether to print the plot}

\item{verbose}{logical whether to print messages}

\item{...}{useless here}
}
\description{
Estimates the r2 to calibrate the degree for \link{npoly} and \link{opoly} methods.
Also returns a plot
}
\details{
May be long, so you can estimate it on a sample either with id here, or one of
\link{sample_n} or \link{sample_frac}
}
\examples{
\dontrun{
calibrate_r2(olea, "opoly", degree.range=1:5, thresh=c(0.9, 0.99))
}

}
\seealso{
Other calibration: \code{\link{calibrate_deviations}},
  \code{\link{calibrate_harmonicpower}},
  \code{\link{calibrate_reconstructions}}
}

