\name{cta20}
\Rdversion{0.1}
\alias{cta20}
\alias{logcta20}
\alias{cta20.hmac}
\alias{logcta20.hmac}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Two dimensional data in original and log scale 
}
\description{
Two dimensional data in original and log scale and their hierarchical modal
clustering. This dataset demonstrates the fact that modal clustering
techniques can be used to cluster untransformed data as it does not
depend on parametric assumptions. The clustering results,
before and after the log transformation both produce nice separation of
the three clusters.
}


\usage{
data(cta20)
data(cta20.hmac)
data(logcta20)
data(logcta20.hmac)
}

\format{ cta20 and logcta20 are two dimensional
  matrices. cta20.hmac and logcta20.hmac are objects of class hmac
  obtained from applying \code{phmac} on  cta20 and logcta20 respectively}
  
\details{The dataset is generated by illumina technology  for high
  throughput genotyping named \bold{GOLDEN GATE} (
  \url{http://www.illumina.com/technology/goldengate_genotyping_assay.ilmn}).
The data values are actual measurements made by the machine (intensity), after these are normalized (background subtracted etc).
  The data set is used for making genotype calls by Illumina. The data
  around X- and Y-axes represents the two homozygous
  genotypes (e.g. AA and TT), while the cluster along the 45-degree line represents the
  heterozygous (e.g. AT) genotype. Due to noisy reads, the data points often
  lie in-between the axes, and cluster detection is used for making
  automatic genotype calls.
}

%


\author{
Surajit Ray and Yansong Cheng
}

%
\examples{
data(logcta20)
data(logcta20.hmac)
plot(logcta20)
plot(logcta20.hmac)
plot(logcta20.hmac,level=4)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{data}

