% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motbf.R
\name{derivMoTBF}
\alias{derivMoTBF}
\title{Derivating MoTBFs}
\usage{
derivMoTBF(fx)
}
\arguments{
\item{fx}{An object of class \code{"motbf"}.}
}
\value{
The derivative of the MoTBF function, which is also 
an object of class \code{"motbf"}.
}
\description{
Compute the derivative of a one-dimensional mixture of truncated basis function.
}
\examples{

## 1. EXAMPLE
X <- rexp(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
derivMoTBF(Px)

## 2. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
derivMoTBF(Px)

## 3. EXAMPLE
X <- rchisq(1000, df = 3)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
derivMoTBF(Px)

\dontrun{
## 4. EXAMPLE
Px <- "x+2"
class(Px)
derivMoTBF(Px)
## Error in derivMoTBF(Px): "fx is not an 'motbf' function."
}
}
\seealso{
\link{univMoTBF}, \link{derivMOP} and \link{derivMTE}
}
