% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{learnMoTBFpriorInformation}
\alias{learnMoTBFpriorInformation}
\title{Incorporating Prior Knowledge}
\usage{
learnMoTBFpriorInformation(
  priorData,
  data,
  s,
  POTENTIAL_TYPE,
  domain = range(data),
  coeffversion = 4,
  restrictDomain = TRUE,
  maxParam = NULL
)
}
\arguments{
\item{priorData}{A \code{"numeric"} array which contains the values of the variable we have information apriori about.}

\item{data}{A \code{"numeric"} array which contains the values to fit.}

\item{s}{A \code{"numeric"} coefficient which fixes the confidence of the prior knowledge 
we are going to introduce. By default it is \code{NULL}, only we must modify it if we want 
to incorporate prior information to the fits.}

\item{POTENTIAL_TYPE}{A \code{"character"} string specifying the posibles potential
types, must be one of \code{"MOP"} or \code{"MTE"}.}

\item{domain}{A \code{"numeric"} array which contains the limits to defined the data function.
By default it is the range of the data.}

\item{coeffversion}{A \code{"numeric"} value between \code{1--4} which contains the used version for computing the coefficients of the linear opinion pool to
combine the prior function and the data function. By default \code{coeffversion = "4"} is used, so the combination
depends on the goodness of the model versus another random model.}

\item{restrictDomain}{This argument lets us choose if the domain is used joining both domains,
the prior one and the data domain or trimming them. By default \code{TRUE} is used, so 
the domain will be trimmed.}

\item{maxParam}{A \code{"numeric"} value which indicates the maximum number of coefficients in the function. By default it is \code{NULL}; 
if not, the output is the function which gets the best BIC with at most this number of parameters.}
}
\value{
A list with the elements
\item{coeffs}{An \code{"numeric"} array with the two coefficients of the linear opinion pool}
\item{posteriorFunction}{The final function after combining.}
\item{priorFunction}{The fit of the prior data.}
\item{dataFunction}{The fit of the original data.}
\item{rangeNewPriorData}{A \code{"numeric"} vector which contains the final domain where the functions are defined.}
}
\description{
Learns a function using prior information.
}
\examples{

## Data
X <- rnorm(15)

## Prior Data
priordata <- rnorm(5000)

## Test data
test <- rnorm(1000)
testData <- test[test>=min(X)&test<=max(X)]

## Learning
type <- "MOP" 
confident <- 3 ## confident <- 1,2,...,length(X)
f <- learnMoTBFpriorInformation(priorData = priordata, data = X, s = confident,
POTENTIAL_TYPE = type)
attributes(f)

## Log-likelihood
sum(log(as.function(f$dataFunction)(testData)))
sum(log(as.function(f$posteriorFunction)(testData))) ## best loglikelihood


}
\seealso{
\link{getCoefficients}
}
