% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoTBFClass.R
\name{Class-JointMoTBF}
\alias{Class-JointMoTBF}
\alias{jointmotbf}
\alias{print.jointmotbf}
\alias{as.character.jointmotbf}
\alias{as.list.jointmotbf}
\alias{is.jointmotbf}
\title{Class \code{"jointmotbf"}}
\usage{
jointmotbf(x = 0)

\method{print}{jointmotbf}(x, ...)

\method{as.character}{jointmotbf}(x, ...)

\method{as.list}{jointmotbf}(x, ...)

is.jointmotbf(x, class = "jointmotbf")
}
\arguments{
\item{x}{Preferably, a list containing, a joint expression
and other posibles elements like a \code{"numeric"} matrix with the domain of the variables, 
the dimension of the variables, the number of iterations needed to solve the optimization problem,
among others. Any \R object can be entered, but the utility of this function is not to transform
objects of other classes into objects of class \code{"jointmotbf"}.}

\item{...}{Additional arguments, not needed for these methods.}

\item{class}{By default is \code{"jointmotbf"}.}
}
\description{
Defines an object of class \code{"jointmotbf"} and other basis functions for 
manipulating \code{"jointmotbf"} objects.
}
\examples{
## n.parameters is the product of the dimensions
dim <- c(3,3)
param <- seq(1,prod(dim), by=1)
## Joint Function 
f <- list(Parameters=param, Dimensions=dim)
jointF <- jointMoTBF(f)

print(jointF) ## jointF
as.character(jointF)
as.list(jointF)
is(jointF)
is.jointmotbf(jointF)
}
\seealso{
\link{jointMoTBF}
}
