% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{as.Mclust}
\alias{as.Mclust}
\title{Convert MoEClust objects to the Mclust class}
\usage{
as.Mclust(x, resid = FALSE, signif = 0, ...)
}
\arguments{
\item{x}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}} or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}.}

\item{resid}{Logical indicating whether to treat the data as the raw data (when \code{FALSE}, the default) or the augmented data comprising the residuals from the expert network (when \code{TRUE} and the model actually contains expert covariates). In the latter case, the mean and (co)variance parameters are taken to be the mean and (co)variance of the residuals. Only relevant if expert network covariates were supplied to \code{x}, otherwise coerced to \code{FALSE}.}

\item{signif}{Significance level for outlier removal. Must be a single number in the interval [0, 1). Corresponds to the percentage of data to be considered extreme and therefore removed (half of \code{signif} at each endpoint, on a column-wise basis). The default, \code{0}, corresponds to no outlier removal. \strong{Only} invoke this argument as an aid to visualisation via \code{\link[mclust]{plot.Mclust}}.}

\item{...}{Further arguments to be passed to other methods.}
}
\value{
An object of class \code{"Mclust"}. See \code{methods(class="Mclust")} for a list of functions which can be applied to this class.
}
\description{
Converts an object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}} and converts it to an object of class \code{"Mclust"} as generated by fitting \code{\link[mclust]{Mclust}}, to facilitate use of plotting and other functions for the \code{"Mclust"} class within the \pkg{mclust} package.
}
\details{
Of course, the user is always encouraged to use the dedicated \code{\link[=plot.MoEClust]{plot}} function for objects of the \code{"MoEClust"} class instead, but calling \code{plot} after converting via \code{\link{as.Mclust}} can be particularly useful for univariate mixtures.

In the presence of expert network covariates, the component-specific covariance matrices are modified for plotting purposes via the function \code{\link{expert_covar}}, in order to account for the extra variability of the means, usually resulting in bigger shapes & sizes for the MVN ellipses.

The \code{signif} argument is intended only to aid visualisation via \code{\link[mclust]{plot.Mclust}}, as plots therein can be sensitive to outliers, particularly with regard to axis limits. This is especially true when \code{resid} is \code{TRUE} in the presence of expert network covariates.
}
\note{
Of the functions which can be applied to the result of the conversion, \code{\link[mclust]{logLik.Mclust}} shouldn't be trusted in the presence of either expert network covariates, or (for more models with more than 1 component) gating network covariates.

Mixing proportions are averaged over observations in components in the presence of gating network covariates during the coercion.

Plots may be misleading in the presence of expert covariates when the \code{what} argument is \code{"density"} within \code{\link[mclust]{plot.Mclust}}.

Also note that plots may be misleading for models of univariate data with more than 1 component, in the presence of expert covariates when \code{resid} is \code{TRUE} and the \code{what} argument is either \code{"classification"} or \code{"uncertainty"} within \code{\link[mclust]{plot.Mclust}}.
}
\examples{
\dontrun{
# Fit a mixture of experts model to the ais data
data(ais)
mod <- MoE_clust(ais[,3:7], G=3, gating= ~ sex, network.data=ais)

# Convert to the "Mclust" class and examine the classification
plot(as.Mclust(mod), what="classification")

# Examine the density using the augmented data in the expert network
plot(as.Mclust(mod, resid=TRUE), what="density")

# While we could have just used plot.MoEClust above,
# plot.Mclust is especially useful for univariate data
data(CO2data)
res <- MoE_clust(CO2data$CO2, G=2, expert = ~ GNP, network.data=CO2data)
plot(as.Mclust(res))}
}
\references{
C. Fraley and A. E. Raftery (2002). Model-based clustering, discriminant analysis, and density estimation. \emph{Journal of the American Statistical Association}, 97:611-631.
}
\seealso{
\code{\link[mclust]{Mclust}}, \code{\link[mclust]{plot.Mclust}}, \code{\link{MoE_clust}}, \code{\link{plot.MoEClust}}, \code{\link{expert_covar}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{utility}
