% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.class.R
\name{set.class}
\alias{set.class}
\title{Export estimated breeding values}
\usage{
set.class(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  new.class = 0
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{new.class}{Class to change to (either single character or vector for each individual when just a single group is selected)}
}
\value{
Population-List with newly entered class values
}
\description{
Function to export estimated breeding values
}
\examples{
data(ex_pop)
population <- set.class(ex_pop, database=cbind(1,1), new.class = 2)
}
