% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hypothesis_test.R
\name{Hypothesis_test}
\alias{Hypothesis_test}
\title{Hypothesis testing for finite mixture models}
\usage{
Hypothesis_test(x, n, alp = 0.1, k = 4, ite = 5, init = 5)
}
\arguments{
\item{x}{observations}

\item{n}{length of x}

\item{alp}{alpha level of the test}

\item{k}{test 2 to k components}

\item{ite}{time of bootstrap}

\item{init}{initial value of number of components}
}
\value{
ks:KS statistic,
cvm: Cramér–von Mises statistic,
kui:Kuiper's statistic,
wat: Watson statistic,
ad:Anderson Darling statistic
result: test result based on KS statistic
1: k component is significant according to KS statistic; 0:o.w.
}
\description{
Test how many component in the data based on KS statistic.
}
\examples{
n<- 100
mu <- c(-2.5,0); sd <- c(0.8,0.6); w <- c(0.3,0.7)
n1=rbinom(n,1,0.3)
 x=c(rnorm(sum(n1),mu[1],sd[1]),rnorm(n-sum(n1),mu[2],sd[2]))
\donttest{out=Hypothesis_test(x,n,alp = 0.10,k = 4,ite = 2,init = 5)}
}
