% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixAll.R
\docType{package}
\name{MixAll-package}
\alias{MixAll-package}
\title{MixAll
Allows to estimate parametric mixture models with mixed data
 sets and missing data.}
\description{
This package contains methods allowing R users to use the clustering methods
of the STK++ library.
}
\details{
As described at the STK++ project's home page, \url{https://www.stkpp.org},
STK++ is a versatile, fast, reliable and elegant collection of C++ classes
for statistics, clustering, linear algebra, arrays (with an Eigen-like API),
regression, dimension reduction, etc. Some functionalities provided by the
library are available in the R environment as R functions in MixAll.

The available functionalities are:
\enumerate{
   \item Clustering (\link{clusterDiagGaussian}, \link{clusterCategorical},
\link{clusterPoisson}, \link{clusterGamma}, \link{clusterMixedData})
   \item Learning ( (\link{learnDiagGaussian}, \link{learnCategorical},
\link{learnPoisson}, \link{learnGamma}, \link{learnMixedData}),
   \item Prediction (\link{clusterPredict}).
 }
}
\author{
Serge Iovleff
}
