% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prefilter.R
\name{prefilter}
\alias{prefilter}
\title{Prefilter}
\usage{
prefilter(xset, subgroup = NULL, unlabel = NULL, reps = TRUE,
  p = 0.05, folds = 10)
}
\arguments{
\item{xset}{xcms object.}

\item{subgroup}{subset the xcms groups. The name should be the same as in phboData$class. default = NULL, which means no subset will be performed.}

\item{unlabel}{specify which is unlabeled group.}

\item{reps}{if there are replicates in the sample.}

\item{p}{p-value threshold, default value = 0.05}

\item{folds}{fold change threshold, default value = 10}
}
\value{
a filtered peaklist
}
\description{
prefiltering isotopically labeled analytes according to the experiment design.
}
\examples{
data(lcms)
explist <- prefilter(lcms, subgroup = c("B", "C", "D"), unlabel = "B")
}
