% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{multi_biplot_pq}
\alias{multi_biplot_pq}
\title{Visualization of a collection of couples of samples for comparison}
\usage{
multi_biplot_pq(physeq, split_by = NULL, pairs = NULL, na_remove = TRUE, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{split_by}{(required if pairs is NULL) the name of the factor to make all combination
of couples of values}

\item{pairs}{(required if pairs is NULL) the name of the factor in physeq@sam_data` slot
to make plot by pairs of samples. Each level must be present only two times.
Note that if you set pairs, you also must set fact arguments to pass on to \code{\link[=biplot_pq]{biplot_pq()}}.}

\item{na_remove}{(logical, default TRUE) if TRUE remove all the samples
with NA in the \code{split_by} variable of the \code{physeq@sam_data} slot}

\item{...}{Other parameters passed on to \code{\link[=biplot_pq]{biplot_pq()}}}
}
\value{
a list of ggplot object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This allow to plot all the possible \code{\link[=biplot_pq]{biplot_pq()}} combination
using one factor.
}
\examples{
\donttest{
data_fungi_abun <- subset_taxa_pq(data_fungi, taxa_sums(data_fungi) > 10000)
p <- multi_biplot_pq(data_fungi_abun, "Height")
lapply(p, print)
}
}
\author{
Adrien Taudière
}
