% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{assign_idtaxa}
\alias{assign_idtaxa}
\title{A wrapper of \code{\link[DECIPHER]{IdTaxa}}}
\usage{
assign_idtaxa(
  physeq,
  seq2search = NULL,
  trainingSet = NULL,
  fasta_for_training = NULL,
  behavior = "return_matrix",
  threshold = 60,
  column_names = c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species"),
  suffix = "_idtaxa",
  nproc = 1,
  unite = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{seq2search}{A DNAStringSet object of sequences to search for.}

\item{trainingSet}{An object of class Taxa and subclass
Train compatible with the class of test.}

\item{fasta_for_training}{A fasta file (can be gzip) to train the trainingSet
using the function \code{\link[=learn_idtaxa]{learn_idtaxa()}}. Only used if trainingSet is NULL.

The reference database must contain
taxonomic information in the header of each sequence in the form of a string
starting with ";tax=" and followed by a comma-separated list of up to nine
taxonomic identifiers.

The only exception is if \code{unite=TRUE}. In that case the UNITE taxonomy is
automatically formatted.}

\item{behavior}{Either "return_matrix" (default), or "add_to_phyloseq":
\itemize{
\item "return_matrix" return a list of two objects. The first element is
the taxonomic matrix and the second element is the raw results from
DECIPHER::IdTaxa() function.
\item "return_cmd" return the command to run without running it.
\item "add_to_phyloseq" return a phyloseq object with amended slot \verb{@taxtable}.
Only available if using physeq input and not seq2search input.
}}

\item{threshold}{(Int, default 60) Numeric specifying the confidence at which
to truncate the output taxonomic classifications.
Lower values of threshold will classify deeper into the taxonomic tree at
the expense of accuracy, and vise-versa for higher values of threshold. See
\code{\link[DECIPHER:IdTaxa]{DECIPHER::IdTaxa()}} man page.}

\item{column_names}{(vector of character) names for the column of the
taxonomy}

\item{suffix}{(character) The suffix to name the new columns.
Default to "_idtaxa".}

\item{nproc}{(default: 1)
Set to number of cpus/processors to use}

\item{unite}{(logical, default FALSE). If set to TRUE, the fasta_for_training
file is formatted from UNITE format to sintax one, needed in
fasta_for_training. Only used if trainingSet is NULL.}

\item{verbose}{(logical). If TRUE, print additional information.}

\item{...}{Additional arguments passed on to \code{\link[DECIPHER]{IdTaxa}}}
}
\value{
Either a new phyloseq object with additional information in
the @tax_table slot or a list of two objects if behavior is "return_matrix"
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This function is basically a wrapper of functions \code{\link[DECIPHER:IdTaxa]{DECIPHER::IdTaxa()}} and
\code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}}, please cite the DECIPHER package if you use this
function. Note that if you want to specify parameters for the learning step
you must used the trainingSet param instead of the a fasta_for_training. The
training file can be obtain using the function \code{\link[=learn_idtaxa]{learn_idtaxa()}}.

It requires:
\itemize{
\item either a physeq or seq2search object.
\item either a trainingSet or a fasta_for_training
}
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{\link[DECIPHER:IdTaxa]{DECIPHER::IdTaxa()}} if you
use this function.
}
\examples{
\dontrun{
# /!\ The value of threshold must be change for real database (recommend
#  value are between 50 and 70).

data_fungi_mini_new <- assign_idtaxa(data_fungi_mini,
  fasta_for_training = system.file("extdata", "mini_UNITE_fungi.fasta.gz",
    package = "MiscMetabar"
  ), threshold = 20, behavior = "add_to_phyloseq"
)

result_idtaxa <- assign_idtaxa(data_fungi_mini,
  fasta_for_training = system.file("extdata", "mini_UNITE_fungi.fasta.gz",
    package = "MiscMetabar"
  ), threshold = 20
)

plot(result_idtaxa$idtaxa_raw)
}
}
\seealso{
\code{\link[=assign_sintax]{assign_sintax()}}, \code{\link[=add_new_taxonomy_pq]{add_new_taxonomy_pq()}}, \code{\link[=assign_vsearch_lca]{assign_vsearch_lca()}}
}
\author{
Adrien Taudière
}
