% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{LOBOV_accuracies}
\alias{LOBOV_accuracies}
\title{LOBOV_accuracies}
\usage{
LOBOV_accuracies(surrogates, bin_phenotypes, bin_pheno_available, acc_LOBOV)
}
\arguments{
\item{surrogates}{numeric data.frame containing the surrogate values by Bizzarri et al.}

\item{bin_phenotypes}{numeric data.frame with the binarized phenotypes output of binarize_all_pheno}

\item{bin_pheno_available}{vector of strings with the available phenotypes}

\item{acc_LOBOV}{accuracy of LOBOV calculated in Bizzarri et al.}
}
\value{
Boxplot with the accuracies of the LOBOV
}
\description{
Function created to visualize the accuracies in the current dataset compared to the
accuracies in the Leave One Biobank Out Validation in Bizzarri et al.
}
\details{
Comparison of the AUCs of the surrogates in the updated dataset and the
results of the Leave One Biobank Out Validation made in BBMRI-nl.
}
\examples{
require(pROC)
require(plotly)
require(MiMIR)
require(foreach)
require(ggplot2)

#load the dataset
m <- synthetic_metabolic_dataset
p<- synthetic_phenotypic_dataset

#Calculating the binarized surrogates
b_p<-binarize_all_pheno(p)
#Apply a surrogate models and plot the ROC curve
sur<-calculate_surrogate_scores(m, p, MiMIR::PARAM_surrogates, bin_names=colnames(b_p))
p_avail<-colnames(b_p)[c(1:5)]
LOBOV_accuracies(sur$surrogates, b_p, p_avail, MiMIR::acc_LOBOV)

}
\references{
This function was made to vidualize the binarized variables calculated following the rules indicated in the article:
Bizzarri,D. et al. (2022) 1H-NMR metabolomics-based surrogates to impute common clinical risk factors and endpoints. EBioMedicine, 75, 103764, doi: 10.1016/j.ebiom.2021.103764
}
