% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contigInfo.R
\name{contigInfo}
\alias{contigInfo}
\title{contigInfo}
\usage{
contigInfo(ko, contig, withAnnotation = FALSE)
}
\arguments{
\item{ko}{the ko bin which the contig was assembled from}

\item{contig}{contigID (optional)}

\item{withAnnotation}{0j/}
}
\description{
contigInfo function greps the contig related info such as whether its in the MDR
}
\examples{
\dontrun{
To query a specific contig
contigInfo(ko = "K00001", contig="contig00001")
# Sending query
# Query Completed

#        bin             contig MDR spanning readnum length
#1 ko:K00001 K00001:contig00001   1        1    1497   1236
With annotation
   assignment taxid       bin             contig readnum length MDR spanning
1 Bacteroides   816 ko:K00001 K00001:contig00001    1497   1236   1        1
2 Bacteroides   816 ko:K00001 K00001:contig00001    1497   1236   1        1
     Rank
1   genus
2 simTaxa

To query all contigs associated with a KO
contigInfo(ko = "K00001") \%>\% head
#Sending query
#
#Query Completed
#
#   MDR spanning       bin             contig length readnum
#1 <NA>     <NA> ko:K00001 K00001:contig00168    297      31
#2 <NA>     <NA> ko:K00001 K00001:contig00167    298     118
#3    1        0 ko:K00001 K00001:contig00166    298      45
#4    1        0 ko:K00001 K00001:contig00164    299     236
#5    1        1 ko:K00001 K00001:contig00163    300     106
#6 <NA>     <NA> ko:K00001 K00001:contig00162    302     310
}
}
