% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_probabilistic_consensus}
\alias{MetaculR_probabilistic_consensus}
\title{Generate probabilistic consensus from multiple parameterized forecasts}
\usage{
MetaculR_probabilistic_consensus(f)
}
\arguments{
\item{f}{A list of forecasts (see example for necessary structure).}
}
\value{
A list of forecasts.
\item{pdf}{A dataframe of probability density functions corresponding to original forecasts and consensus forecast.}
\item{cdf}{A dataframe of cumulative distribution functions corresponding to original forecasts and consensus forecast.}
\item{summary}{A dataframe of summary statistics corresponding to original forecasts and consensus forecast, i.e., 10th, 25th, 50th, 75th, 90th centiles and mean.}
}
\description{
Generate probabilistic consensus from multiple parameterized forecasts
}
\examples{
\dontrun{
forecasts <- list(list(range = c(0, 250), resolution = 1),
  list(source = "Pishkalo",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(116, 12),
    weight = 0.2),
  list(source = "Miao",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(121.5, 32.9)),
  list(source = "Labonville",
    dist = "TPD",
    params = c("min", "mode", "max"),
    values = c(89-14, 89, 89+29)),
  list(source = "NOAA",
    dist = "PCT",
    params = c(0.2, 0.8),
    values = c(95, 130)),
  list(source = "Han",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(228, 40.5)),
  list(source = "Dani",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(159, 22.3)),
  list(source = "Li",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(168, 6.3)),
  list(source = "Singh",
    dist = "Norm",
    params = c("mu", "sd"),
    values = c(89, 9)))

MetaculR_probabilistic_consensus(
  f = forecasts)
}
}
\references{
McAndrew, T., & Reich, N. G. (2020). An expert judgment model to predict early stages of the COVID-19 outbreak in the United States [Preprint]. Infectious Diseases (except HIV/AIDS). https://doi.org/10.1101/2020.09.21.20196725
}
