% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_myDiff}
\alias{MetaculR_myDiff}
\title{Find important changes within MetaculR_questions object}
\usage{
MetaculR_myDiff(MetaculR_questions)
}
\arguments{
\item{MetaculR_questions}{A MetaculR_questions object}
}
\value{
A dataframe of questions with difference measures (your most recent prediction vs. community's most recent prediction, etc.).
\item{id}{Question ID.}
\item{title}{Question title.}
\item{my_prediction}{My most recent prediction.}
\item{community_q2}{Community median.}
\item{community_ave}{Community average.}
\item{community_q2_pre_me}{Community median immediately prior to my_prediction.}
\item{community_ave_pre_me}{Community average immediately prior to my_prediction.}
\item{diff_me_q2}{Difference between me and the community median, by logodds.}
\item{diff_me_ave}{Difference between me and the community average, by logodds.}
\item{diff_comm_q2_pre_me}{Difference between community_q2_pre_me and the community average, by logodds.}
\item{diff_comm_ave_pre_me}{Difference between community_ave_pre_me and the community average, by logodds.}
\item{diff_me_q2_abs}{Absolute difference between me and the community median, by logodds.}
\item{diff_me_ave_abs}{Absolute difference between me and the community average, by logodds.}
\item{diff_comm_q2_pre_me_abs}{Absolute difference between community_q2_pre_me and the community average, by logodds.}
\item{diff_comm_ave_pre_me_abs}{Absolute difference between community_ave_pre_me and the community average, by logodds.}
\item{diff_me_q2_abs_odds}{Absolute difference between me and the community median, by odds.}
\item{diff_me_ave_abs_odds}{Absolute difference between me and the community average, by odds.}
\item{diff_comm_q2_pre_me_abs_odds}{Absolute difference between community_q2_pre_me and the community average, by odds.}
\item{diff_comm_ave_pre_me_abs_odds}{Absolute difference between community_ave_pre_me and the community average, by odds.}
}
\description{
Find important changes within MetaculR_questions object
}
\examples{
\dontrun{
questions_myPredictions_byDiff <-
  MetaculR_myDiff(
    questions_myPredictions)
}
}
