% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveFactorsByANOVA.R
\name{RemoveFactorsByANOVA}
\alias{RemoveFactorsByANOVA}
\title{RemoveFactorsByANOVA.}
\usage{
RemoveFactorsByANOVA(
  y = NULL,
  sam = NULL,
  fmod = NULL,
  kmod = NULL,
  output = c("y_norm", "y_lm", "anova_y", "anova_y_norm", "boxplot")[1],
  remove_outliers = 0
)
}
\arguments{
\item{y}{Data vector (or data matrix) to normalize (numeric + in same order as sam).}

\item{sam}{data.frame containing the factors or numerical vars for ANOVA model.}

\item{fmod}{Full model describing the experimental setting (provided as character string).}

\item{kmod}{Reduced model describing all the biological factors to keep (provided as character string).}

\item{output}{Should be \code{y_norm} in general but can be switched for testing.}

\item{remove_outliers}{Should be a numeric integer x (with $x=0$ : no effect; $x>=1$ remove all values which have error e with $e > abs(mean + x * sd)$ ).}
}
\value{
Depends on \code{output}. Usually the normalized data vector (or matrix).
}
\description{
\code{RemoveFactorsByANOVA} will remove variance from data using an ANOVA model.
}
\details{
not yet
}
\examples{
# set up sample information
sam <- data.frame("GT"=gl(4,10),
                 "TR"=rep(gl(2,5),4),
                 "Batch"=sample(gl(2,20)),
                 "Order"=sample(seq(-1,1,length.out=40)))
# set up artificial measurement data
set.seed(1)
m1=c(5,6,2,9)[sam$GT]+c(-2,2)[sam$TR]+c(-3,3)[sam$Batch]+3*sam$Order+rnorm(nrow(sam), sd=0.5)
m2=c(5,-6,2,4)[sam$GT]+c(-2,2)[sam$TR]-5*sam$Order+rnorm(nrow(sam), sd=0.8)
dat <- data.frame(m1,m2)

# apply function to remove variance
# full model incorporating all relevant factors defined in sample table
fmod="GT*TR+Batch+Order"
# reduced model: factors to be kept from full model; everything elso will be removed from the data
kmod="GT*TR"
RemoveFactorsByANOVA(y=dat[,"m1"], sam=sam, fmod=fmod, kmod=kmod, output="anova_y")
RemoveFactorsByANOVA(y=dat[,"m1"], sam=sam, fmod=fmod, kmod=kmod, output="anova_y_norm")

}
