% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MRLasso-class}
\alias{MRLasso-class}
\title{MRLasso class}
\description{
An object containing the estimates produced using the MR-Lasso method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Estimate}}{The causal estimate from the MR-Lasso method.}

\item{\code{StdError}}{The standard error associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bounds of the confidence intervals for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bounds of the confidence intervals for \code{Estimate} based on \code{StdError}.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Pvalue}}{P-value associated with the causal estimate from the MR-Lasso method.}

\item{\code{SNPs}}{The number of SNPs used in the calculation.}

\item{\code{RegEstimate}}{The estimate from the regularized regression model used in the MR-Lasso method.}

\item{\code{RegIntercept}}{The intercept estimates from the regularized regression model used in the MR-Lasso method. An intercept estimate of zero identifies the corresponding genetic variant as a valid instrument. Genetic variants with non-zero intercept estimates will be excluded from the post-lasso estimator.}

\item{\code{Valid}}{The number of genetic variants that have been identified as valid instruments.}

\item{\code{ValidSNPs}}{The names of genetic variants that have been identified as valid instruments.}

\item{\code{Lambda}}{The value of the tuning parameter used to compute \code{RegEstimate} (default is to calulate \code{Lambda} using the heterogeneity stopping rule).}
}}

